package bookExamples.ch44Printing.cdLabel;


import futils.Futil;
import gui.ClosableJFrame;
import gui.layouts.VerticalFlowLayout;
import gui.run.RunButton;
import gui.run.RunComboBox;
import utils.PrintUtils;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Date;
import java.util.StringTokenizer;

/**
 * Created by IntelliJ IDEA.
 * User: Dahiana M
 * Date: Oct 2, 2005
 * Time: 10:39:20 PM
 * To change this template use File | Settings | File Templates.
 */
public class CdLabelPrinterFrame extends ClosableJFrame implements ActionListener {
    private JPanel borderPanel = getBorderPanel();

    private File file;

    private String month;
    private String day;
    private int year;

    public JPanel getBorderPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.setBorder(BorderFactory.createEtchedBorder());
        jp.setBackground(Color.white);
        return jp;
    }

    /**
     * This program prints a cd label of all the files contained into a chosen directory
     */
    public CdLabelPrinterFrame() {
        Container c = getContentPane();
        c.setLayout(new BorderLayout());
        c.setBackground(Color.white);
        JMenuBar mb = new JMenuBar();
        setJMenuBar(mb);
        CdLabelPrinterFileMenu.addFileMenu(this, mb);
    }

    /**
     * This is used when user selects file-set date.
     * This method makes sure that the new panel created will contain the same cd labels as before.
     *
     * @param date this date will be used in order to update the cd label with the right date
     */

    public void setLabel(JLabel date) {
        JPanel p = new JPanel(new VerticalFlowLayout());
        p.setBackground(Color.white);
        //the file will alow the same cd labels to be displayed when user selects file-set date
        populatePanel(p, file);
        makeBorderPanel(date, p);
    }

    /**
     * A new panel will be created with a date and cd labels
     *
     * @param date       this assinged date will be used in the new panel
     * @param labelPanel p is the panel that contains the cd labels
     */
    public void makeBorderPanel(JLabel date, JPanel labelPanel) {
        Container c = getContentPane();
        c.remove(borderPanel);
        borderPanel = getBorderPanel();
        borderPanel.add(date, BorderLayout.NORTH);
        borderPanel.add(labelPanel, BorderLayout.CENTER);
        c.add(borderPanel);
        CdLabelPrinterFrame.super.setVisible(true);
    }

    /**
     * This is used when user selects file-open.
     *
     * @param date
     */
    public void showLabel(JLabel date) {
        JPanel p = new JPanel(new VerticalFlowLayout());
        p.setBackground(Color.white);
        populatePanel(p, null);
        makeBorderPanel(date, p);
    }

    /**
     * This gets todays date
     *
     * @return todaysDate - a JLabel with today's date
     */
    public JLabel getDate() {
        final Date date = new Date();
        month = date.toString().substring(4, 8);
        day = date.toString().substring(9, 11);
        year = Integer.parseInt(date.toString().substring(24));
        String todaysDate = month + "" + day + "" + year;
        return new JLabel(todaysDate);
    }

    /**
     * This is called when user selects file-set date
     */
    public void setDate() {
        getDate();//this is here just in case the user wamts to preselect a date before opening a directory
        final JFrame m = new JFrame("Select a Date");
        m.setSize(200, 100);
        m.getContentPane().setLayout(new BorderLayout());
        m.getContentPane().add(getMonthsPanel(), BorderLayout.WEST);
        m.getContentPane().add(getDaysPanel(), BorderLayout.CENTER);
        m.getContentPane().add(getYearsPanel(), BorderLayout.EAST);
        m.getContentPane().add(new RunButton("ok") {
            public void run() {
                setNewDate();
                m.dispose();
            }
        }, BorderLayout.SOUTH);
        m.setVisible(true);

    }

    /**
     * When the ok button is pressed this sets the new date and sends it to the mathod that will
     * add it to the new panel
     */
    public void setNewDate() {
        setDateWithoutSpaces();
        JLabel newDate = new JLabel(month + " " + day + " " + year);
        setLabel(newDate);
    }

    /**
     * This method removes extra spaces. It makes sure that the date's format never gets distorted.
     * For example, instead of Oct5 2005, you will get Oct 5 2005
     */

    private void setDateWithoutSpaces() {
        StringTokenizer m = new StringTokenizer(month, " ");
        month = m.nextToken();
        StringTokenizer d = new StringTokenizer(day, " ");
        day = d.nextToken();
        StringTokenizer y = new StringTokenizer(Integer.toString(year), " ");
        year = Integer.parseInt(y.nextToken());
    }


    /**
     * populatePanel reads a chosen file directory and adds all the files in that directory into a
     * Jpanel
     *
     * @param p is the panel that contains the cd labels
     * @param f is a directory file
     */
    public void populatePanel(JPanel p, File f) {

        if (f == null) {
            f = Futil.getReadDirFileJTree("select a start file");
            file = f;
        }
        JLabel l;
        //f is a directory; we need to list its contents
        File list[] = f.listFiles();
        for (int i = 0; i < list.length; ++i) {
            //I like listings with 1-based indexes.  So sue me.
            if (list[i].isDirectory()) {
                l = new JLabel('\\' + list[i].getName());
            } else {
                l = new JLabel(list[i].getName());
            }
            p.add(l);
        }
    }

    /**
     * This panel contains the combo box with assigend years
     *
     * @return the panel with a runnable comboBox
     */
    private JPanel getYearsPanel() {
        getDate();
        JPanel p = new JPanel();
        RunComboBox years = new RunComboBox(getYears()) {
            public void run() {
                year = Integer.parseInt(getSelectedItem().toString());
            }
        };
        //the following sets the combobox to display todays year
        String yearInString = Integer.toString(year);
        StringTokenizer st = new StringTokenizer(yearInString, " ");
        String token = st.nextToken();
        for (int x = 0; x < years.getItemCount(); x++) {
            if ((years.getItemAt(x).toString()).compareTo(token) == 0) {
                years.setSelectedIndex(x);
            }
        }
        p.add(years);
        return p;
    }

    /**
     * This panel contains the combo box with assigend days
     *
     * @return the panel with a runnable comboBox
     */
    private JPanel getDaysPanel() {
        getDate();
        JPanel p = new JPanel();
        RunComboBox days = new RunComboBox(getDays()) {
            public void run() {
                day = getSelectedItem().toString();
            }
        };
        p.add(days);

        //the following sets the comboBox to display todays date
        StringTokenizer st = new StringTokenizer(day, " "); //the space and the zero needs to be
        //removed before comparison
        String token = st.nextToken();

        for (int x = 0; x < days.getItemCount(); x++) {
            if ((days.getItemAt(x).toString()).compareTo(token) == 0) {
                days.setSelectedIndex(x);
            }
        }
        return p;
    }

    /**
     * This panel contains the combo box with assigend months
     *
     * @return the panel with a runnable comboBox
     */
    public JPanel getMonthsPanel() {
        getDate();
        JPanel p = new JPanel();
        RunComboBox months = new RunComboBox(getMonths()) {
            public void run() {
                month = getSelectedItem().toString();
            }
        };
        //the following sets the comboBox to display todays month
        StringTokenizer st = new StringTokenizer(month, " "); //the space needs to be
        //removed before the string comparison otherswise, strings won't ever be equal
        String token = st.nextToken();
        for (int x = 0; x < months.getItemCount(); x++) {
            if ((months.getItemAt(x).toString()).compareTo(token) == 0) {
                months.setSelectedIndex(x);
            }
        }
        p.add(months);
        return p;
    }

    public static String[] getMonths() {

        return new String[]{"Jan",
                "Feb",
                "Mar",
                "Apr",
                "May",
                "Jun",
                "Jul",
                "Aug",
                "Sept",
                "Oct",
                "Nov",
                "Dec"

        };
    }

    public String[] getYears() {
        //the following sets the years array starting 4 years behind from today's years
        year = year - 4;
        int y = year;
        int count = 0;
        System.out.println("year");
        String years[] = new String[8];
        for (int x = 4; x > 0; x--) {
            years[count] = Integer.toString(y);
            y = year + 1;
            year = y;
            count = count + 1;
        }
        //the following sets the year 3 years later from today's year
        getDate();
        int z = year;
        for (int x = 0; x < 4; x++) {
            years[count] = Integer.toString(z);
            z = year + 1;
            year = z;
            count = count + 1;
        }
        getDate();
        return years;
    }


    public static String[] getDays() {
        String days[] = new String[31];
        for (int x = 0; x < 31; x++) {
            days[x] = Integer.toString(x + 1);
        }
        return days;
    }

    public void actionPerformed(ActionEvent e) {
    }

    public static void main(String args[]) {
        CdLabelPrinterFrame fc = new CdLabelPrinterFrame();
        fc.setSize(357, 369);
        fc.setTitle("CD Label Printer");
        fc.setVisible(true);
    }

    public void print() {
        PrintUtils.printComponent(borderPanel);
    }

    public JLabel getDateLabel() {
        return new JLabel(month + " " + day + " " + year);
    }
}
