package bookExamples.ch44Printing.cdLabel;


import gui.run.RunMenu;
import gui.run.RunMenuItem;
import utils.PrintUtils;

import javax.swing.*;

import bookExamples.ch44Printing.cdLabel.CdLabelPrinterFrame;

/**
 * Created by IntelliJ IDEA.
 * User: Dahiana M
 * Date: Oct 2, 2005
 * Time: 9:53:36 PM
 * To change this template use File | Settings | File Templates.
 */
public class CdLabelPrinterFileMenu {
    public static void addFileMenu(final CdLabelPrinterFrame frame, JMenuBar mb) {
        RunMenu fileMenu = new RunMenu("[File");
        mb.add(fileMenu);

        fileMenu.add(new RunMenuItem("[Open{ctrl O}",
                MyHex.getOpenIcon()) {
            public void run() {
                frame.showLabel(frame.getDate());
            }
        });

        fileMenu.add(new RunMenuItem("[Print {ctrl p}",
                MyHex.getPrinterIcon()) {
            public void run() {
                //the following makes sure that the display remains the same. Without this
                //PrintUtils.printComponents... returned a display with today's date, and not with the date
                //that I had assigned before I printed the label.
                JLabel recordedDate = frame.getDateLabel();
                frame.print();
                System.out.println(recordedDate);
                frame.setLabel(recordedDate);
            }
        });

        fileMenu.add(new RunMenuItem("[Set Date{ctrl s}",
                MyHex.getClockIcon()) {
            public void run() {
                frame.setDate();

            }
        });
        fileMenu.add(new RunMenuItem("[Quit{ctrl Q}",
                MyHex.getExitIcon()) {
            public void run() {
                frame.dispose();
            }
        });
    }
}
