package bookExamples.ch44Printing;

//Paul S. Underwood
//SW409
//April 13, 2005


import futils.Futil;
import gui.ClosableJFrame;
import gui.layouts.VerticalFlowLayout;
import utils.PrintUtils;

import javax.swing.*;
import java.awt.*;
import java.io.File;
import java.util.Calendar;
import java.util.GregorianCalendar;

/**
 * Created by IntelliJ IDEA. User: Paul Date: Apr 9, 2005 Time: 5:31:33 PM
 * To change this template use File | Settings | File Templates.
 */

public class CdLabelPrinter extends ClosableJFrame {
    CdLabelPrinter() {
        Container c = getContentPane();
        JPanel borderPanel = new JPanel();
        borderPanel.setLayout(new BorderLayout());
        borderPanel.setBorder(BorderFactory.createEtchedBorder());
        borderPanel.setBackground(Color.white);
        c.setBackground(Color.white);
        c.setLayout(new BorderLayout());
        borderPanel.add(getDateLabel(), BorderLayout.NORTH);
        JPanel p = new JPanel(new VerticalFlowLayout());
        p.setBackground(Color.white);
        populatePanel(p);
        borderPanel.add(p, BorderLayout.CENTER);
        c.add(borderPanel);
        this.setTitle(getDateLabel().getText());
    }

    void populatePanel(JPanel p) {
        //FileList fl = new FileList();
        File f = Futil.getReadDirFileJTree("select a start file");
        //f is a directory; we need to list its contents
        File list[] = f.listFiles();

        JLabel l= new JLabel(f.getName() + ": " + getDateLabel());
        for (int i = 0; i < list.length; ++i) {
            //I like listings with 1-based indexes.  So sue me.
            if (list[i].isDirectory()) {
                l = new JLabel('\\' + list[i].getName());
            } else {
                l = new JLabel(list[i].getName());
            }
            p.add(l);
        }
    }

    static JLabel getDateLabel() {
        GregorianCalendar gc = new GregorianCalendar();
        String date = Integer.toString(gc.get(Calendar.YEAR));
        if (gc.get(Calendar.MONTH) < 10) date = date + '0';
        date += Integer.toString(gc.get(Calendar.MONTH) + 1);
        if (gc.get(Calendar.DAY_OF_MONTH) < 10) date = date + '0';
        date += Integer.toString(gc.get(Calendar.DAY_OF_MONTH));
        return new JLabel(date);
    }

    public static void main(String[] args) {
        CdLabelPrinter labelPrinter = new CdLabelPrinter();
        labelPrinter.setSize(357, 369);
        labelPrinter.setVisible(true);
        try {
            Thread.sleep(200);
        } catch (InterruptedException e) {

        }
        PrintUtils.printComponent(labelPrinter);
    }
}
