package bookExamples.ch26Graphics.radar;

import java.awt.*;


public class Radar extends java.awt.Canvas {

    private double thetaInRadians = 0;
    private Target targets[] = {
        new Target("t1", 30, 50)
    };

    Radar(int w, int h) {
        setSize(w, h);
    }

    public void paint(java.awt.Graphics g) {
        java.awt.Dimension d = getSize();
        double deltaTheta =
                3 * Math.PI / 180.0;
        int width = d.width;
        int height = d.height;
        int xc = width / 2;
        int yc = height / 2;
        g.setColor(java.awt.Color.red);

        int r = Math.min(xc, yc);
        double xr =
                r * Math.cos(getThetaInRadians()) + xc;
        double yr =
                r * Math.sin(getThetaInRadians()) + yc;
        setThetaInRadians(getThetaInRadians() + deltaTheta);
        //for (int i = 0; i < getTargets().length; i++)
        //    getTargets()[i].draw(g);
       // g.setXORMode(Color.red);
        g.drawLine(xc, yc, (int) xr, (int) yr);
        g.setColor(java.awt.Color.BLUE);
        g.drawString("target", (int) xr, (int) yr);
        sleep(50);
        repaint();
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void main(String args[]) {
        gui.ClosableJFrame cf = new gui.ClosableJFrame();
        java.awt.Container c = cf.getContentPane();
        Radar r = new Radar(200, 200);
        c.add(r);
        c.setLayout(
                new GridLayout(1, 0));
        cf.setSize(200, 200);
        cf.setVisible(true);
    }

    public double getThetaInRadians() {
        return thetaInRadians;
    }

    public void setThetaInRadians(double thetaInRadians) {
        this.thetaInRadians = thetaInRadians;
    }

    public Target[] getTargets() {
        return targets;
    }

    public void setTargets(Target[] targets) {
        this.targets = targets;
    }
}
