package bookExamples.ch26Graphics.graphics;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.AffineTransform;


class HousePanel extends JPanel {
    public double rx = 0, ry = 0, scale = 0, theta = 0;

    public HousePanel() {
    }

    public void symbolValues() {
        java.awt.Dimension d = getSize();
        scale = Math.random();
        rx = Math.random() * d.width;
        ry = Math.random() * d.height;
        theta = Math.random() * 360;

    }


    public void drawHouse(Graphics2D g) {
        g.setColor(Color.RED);
        g.drawRect(150, 150, 200, 200);
        g.setColor(Color.BLACK);
        g.drawRect(230, 275, 40, 75);
        g.setColor(Color.green);
        g.drawRect(175, 175, 50, 50);
        g.drawRect(275, 175, 50, 50);
        g.setColor(Color.blue);
        g.drawLine(150, 150, 250, 50);
        g.drawLine(250, 50, 350, 150);
    }

    public void paint(Graphics g) {
        setBackground(Color.white);
        if (g instanceof Graphics2D) {
            System.out.println("g=" + g.getClass().getName());
        }
        Graphics2D g2d = (Graphics2D) g;
        AffineTransform at = new AffineTransform();
        for (int i = 0; i < 50; i++) {
            symbolValues();
            at.setToTranslation(rx, ry);
            at.scale(scale, scale);
            at.rotate(theta * Math.PI / 180);
            g2d.setTransform(at);
            drawHouse(g2d);
        }
    }
}

public class JHouseApp {
    public static void main(String args[]) {
        JFrame hf = new JFrame("AffineFrame");
        hf.setSize(200, 200);
        hf.setBackground(Color.white);
        hf.getContentPane().add(
                new HousePanel());
        hf.setVisible(true);
    }
}
