package bookExamples.ch26Graphics.draw2d;

import gui.In;
import gui.run.RunButton;
import gui.run.RunSlider;

import javax.swing.*;
import java.awt.*;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

public class Square2d extends DJShape
        implements PropertyEditor {
    int h = 1;
    int w = 1;
    int xc = 0;
    int yc = 0;

    PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public DJShape getInstance(int x1, int y1, int x2, int y2) {
        return new Square2d(x1, y1, x2, y2);
    }

    public int getX1() {
        return x1;
    }

    public int getY1() {
        return y1;
    }

    public int getW() {
        return w;
    }

    public int getH() {
        return h;
    }

    public Square2d(int _x1, int _y1, int _x2, int _y2) {
        super(_x1, _y1, _x2, _y2);
        setX1(_x1);
        setY1(_y1);
        w = Math.abs(_x2 - x1);
        h = Math.abs(_y2 - y1);
        if (_x1 > _x2) setX1(_x2);
        if (_y1 > _y2) setY1(_y2);
        xc = x1 + w / 2;
        yc = y1 + h / 2;

    }

    public Point getCenter() {
        return new Point(x1 + w / 2, y1 + w / 2);
    }

    public void draw(Graphics g) {
        Point pc = getCenter();

        Graphics2D g2d = (Graphics2D) g;
        AffineTransform old = g2d.getTransform();
        AffineTransform affineTransform = getAffineTransform();
        g2d.transform(affineTransform);
        g2d.setColor(getForeground());
        xc = (int) pc.getX();
        yc = (int) pc.getY();
        g2d.drawRect(x1, y1, w, w);
        g2d.fillOval(xc, yc, 2, 2);
        g2d.drawString("(" + xc + "," + yc + ")", xc + 3, yc + 3);
        g2d.setTransform(old);
    }

    /* public void draw(Graphics g) {
         //saveState(g);

         Point pc = getCenter();

         Graphics2D g2d = (Graphics2D) g;
         AffineTransform old = g2d.getTransform();
         AffineTransform affineTransform = getAffineTransform();
         g2d.transform(affineTransform);
         g2d.setColor(getForeground());
         int radius = diameter / 2;
         x1 = pc.x - radius;
         y1 = pc.y - radius;
         g2d.drawOval(x1, y1, diameter, diameter);

         g2d.fillOval(pc.x, pc.y, 2, 2);
         g2d.drawString("(" + pc.x + "," + pc.y + ")", pc.x + 3, pc.y + 3);
         g2d.drawLine(pc.x, pc.y, pc.x - radius, pc.y);
         g2d.setTransform(old);

     }*/

    public Component getCustomEditor() {
        JPanel jp = new JPanel();
        jp.add(new JLabel("size"));
        jp.add(new RunSlider(RunSlider.HORIZONTAL, 1, 2000, w) {
            public void run() {
                pcs.firePropertyChange("square", this, null);
                w = getValue();
            }
        });
        jp.add(new RunButton("color") {
            public void run() {
                Color c = In.getColor();
                pcs.firePropertyChange("square", this, null);
                Square2d.this.setForeground(c);
            }
        });
        jp.add(getRunAffinePanel());

        jp.setLayout(new FlowLayout());

        return jp;
    }

    public boolean isPaintable() {
        return false;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Object getValue() {
        return null;
    }

    public void setValue(Object newValue) {
    }

    public String getAsText() {
        return null;
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String[] getTags() {
        return new String[0];
    }

    public void setAsText(String text) throws IllegalArgumentException {
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }
}

