package bookExamples.ch26Graphics.draw2d;


import java.awt.*;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;

public class Lens2d extends DJShape {
    private int w = 1;
    private int h = 1;
    private int xc = 0;
    private int yc = 0;
    private int startAngle = 90;
    private int arcAngle = 180;
    private Line2d plane = null;

    public DJShape getInstance(int x1, int y1, int x2, int y2) {
        Lens2d lens2d = new Lens2d(x1, y1, x2, y2);
        lens2d.setAffineTransform(getAffineTransform());
        return lens2d;
    }

    public Lens2d(int x1, int y1, int x2, int y2) {
        super(x1, y1, x2, y2);
        setX1(x1);
        setY1(y1);
        w = Math.abs(x2 - this.x1);
        h = Math.abs(y2 - this.y1);
        int _x1PluswOn2 = x1 + w / 2;
        plane = new Line2d(_x1PluswOn2, y1, _x1PluswOn2, y1 + h);
        xc = this.x1 + w / 2;
        yc = this.y1 + h / 2;
    }


    public Point getCenter() {
        return new Point(xc - w / 4, yc);
    }

    public void draw(Graphics g) {

        Point2D pc = getCenter();
        int x = (int) pc.getX();
        int y = (int) pc.getY();
        Graphics2D g2d = (Graphics2D) g;
        g2d.setColor(getForeground());
        g2d.drawArc(x1, y1, w, h, startAngle, arcAngle);
        g2d.drawLine(plane.x1, plane.y1, plane.x2, plane.y2);
        g2d.fillOval(x, y, 2, 2);
        g2d.drawString("(" + x + "," + y + ")", x + 3, y + 3);

    }

    public boolean isPaintable() {
        return false;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public Component getCustomEditor() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public Object getValue() {
        return null;
    }

    public void setValue(Object value) {
    }

    public String getAsText() {
        return null;
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String[] getTags() {
        return new String[0];
    }

    public void setAsText(String text) throws IllegalArgumentException {
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }
}
