package bookExamples.ch18Swing.awt;

import javax.swing.*;
import java.awt.*;

public class PackExample extends JFrame {
    PackExample() {
        Container c = getContentPane();
        c.setLayout(new GridLayout(2, 0));
        c.add(new DebugButton());
        c.add(new DebugButton());
        c.add(new DebugButton());
        c.add(new DebugButton());
        c.add(new DebugButton());
        setSize(200, 200);
        setVisible(true);

    }

    public static void main(String args[]) {
        PackExample le = new PackExample();
        System.out.println("pack!");
        le.pack();
    }

    class DebugButton extends JButton {
        DebugButton() {
            super("debugButton");
            setPreferredSize(null);
        }

        public Dimension getPreferredSize() {
            System.out.println("getPreferredSize:"
                    + super.getPreferredSize());
            return super.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            System.out.println("getMinimumSize:"
                    + super.getMinimumSize());
            return super.getMinimumSize();
        }

        public void setPreferredSize(Dimension d) {
            System.out.println("setPrefferedSize:"
                    + d);
            super.setPreferredSize(d);
        }

        public void setMinimumSize(Dimension d) {
            System.out.println("setMinimumSize:"
                    + d);
            super.setMinimumSize(d);
        }
    }
}
