package bookExamples.ch13Threads;

public class ThreadTest {

    public static void main(String args[]) {
        int numberOfThreads = 5;
        Thread t[] = new Thread[numberOfThreads];
        System.out.println("Beginning thread test:");
        for (int i=0; i < t.length; i++) {
            t[i] = new Thread(new Hello(i));
            t[i].start();
        }
    }
}


class Hello implements Runnable {
    int i = 0;
    int numberOfTimesRun = 0;
    private static int totalNumberOfTimesRun = 0;

    Hello(int id) {
        i = id;
    }
    public static synchronized void incrementNumberOfTimes(){
        totalNumberOfTimesRun++;
    }
    public void run() {
        for (int j = 0; j < 10; j++) {
            incrementNumberOfTimes();
            System.out.println(
                    "Hello #" + i +
                    " numberOfTimesRun=" + numberOfTimesRun++ +
                    "totalNumberOfTimesRun="+totalNumberOfTimesRun);
            try {
                Thread.sleep(
                        (int) (Math.random() * 1000));
            } // try
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } // for
        System.out.println("Hello #" + i + " is done!");
    }
}
