package bookExamples.ch12Nested.inner;

class Inner {
    public static void main(String args[]) {
        Bank b = new Bank();
        System.out.println(b.getCustomer().getName());
    }
}

// run using:
// examples.inner.Job

abstract class Job {
    static Job j = new EdsJob();

    Thread t = null;

    Job(Runnable r) {
        t = new Thread(r);
        t.start();
    }

    abstract void killMe();

    public static void main(String args[]) {
        j.killMe();
    }

    private static class EdsJob extends Job {
        public EdsJob() {
            super(new Runnable() {
                public void run() {
                    System.out.println("Hidee hoe!");
                }
            });
        }

        public void killMe() {
            System.out.println("test");
        }
    }
}

class Bank {
    Customer getCustomer() {
        return new Customer() {
            String getName() {
                return "Frank";
            }
        };
    }
}

abstract class Customer {
    abstract String getName();
}

interface MetricFcn {
    double metric2English(double d);

    double english2Metric(double d);
}

class Meters2Yards {
    static MetricFcn meters2Yards = new MetricFcn() {
        public double metric2English(double d) {
            return d / 1.1;
        }

        public double english2Metric(double d) {
            return d * 1.1;
        }
    };

    public static void main(String args[]) {
        System.out.println("10 meters =" +
                meters2Yards.metric2English(10) + " yards");
    }
}

interface Command {
    public void run();
}

class Commando {
    Command getCommand() {
        return new Command() {
            public void run() {
                System.out.println("hello world!");
            }
        };
    }

    public void doit() {
        getCommand().run();
    }

    public static void main(String args[]) {
        Commando c = new Commando();
        c.doit();
    }
}

class A {
    static int a = 10;

    public static void main(String args[]) {
        System.out.println("a=" + a);
    }
}

class Shadow {
    int a = 10;
    int b = 20;

    void setA(int a) {
        this.a = a;
    }

    void setB(int _b) {
        b = _b;
    }
}

