package bookExamples.ch12Nested;

import java.awt.*;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Oct 4, 2004
 * Time: 3:19:20 PM
 */
public abstract class Shape {
    private int x;
    private int y;
    Shape(int x, int y) {
        this.x  = x;
        this.y = y;
    }
    public abstract void draw(Graphics g);
    // getCircle makes an instance - factory pattern
    // Using an anonymous local inner class....
    public static Shape getCircle(final int x, final int y, final int r) {
        return new Shape(x,y) {
            public void draw(Graphics g) {
               g.drawOval(x,y,2*r,2*r);
            }
        };
    }
      public static Shape getOval(int x, int y, final int w, final int h) {
        return new Oval(x, y, w, h);
    }

    public int getX() {
        return x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return y;
    }

    public void setY(int y) {
        this.y = y;
    }

    // Named static inner class
    private static class Oval extends Shape {
        private final int w;
        private final int h;

        public Oval(int x, int y, int w, int h) {
            super(x, y);
            this.w = w;
            this.h = h;
        }

        public void draw(Graphics g) {
           g.drawOval(getX(),getY(),w,h);

        }
    }
}
