/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package addbk.print.labels;

import javax.swing.*;
import javax.swing.border.MatteBorder;
import java.awt.*;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 30, 2005
 * <p/>
 * Time: 1:34:40 AM
 */
class PagePreview
        extends JPanel {
    protected int m_w;
    protected int m_h;
    protected Image m_source;
    protected Image image;
    private PrintPreview printPreview;

    public PagePreview(
            PrintPreview printPreview, int w, int h, Image image) {
        this.printPreview = printPreview;
        m_w = w;
        m_h = h;
        m_source = image;
        this.image = m_source.getScaledInstance(
                m_w, m_h,
                Image.SCALE_SMOOTH);
        this.image.flush();
        setBackground(Color.white);
        setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
    }

    public void setScaledSize(int w, int h) {
        m_w = w;
        m_h = h;
        image = m_source.getScaledInstance(
                m_w, m_h,
                Image.SCALE_SMOOTH);
        printPreview.repaint();
    }

    public Dimension getPreferredSize() {
        Insets ins = getInsets();
        return new Dimension(
                m_w + ins.left + ins.right,
                m_h + ins.top + ins.bottom);
    }

    public Dimension getMaximumSize() {
        return getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return getPreferredSize();
    }

    public void paint(Graphics g) {
        g.setColor(printPreview.getBackground());
        g.fillRect(0, 0, getWidth(), getHeight());
        g.drawImage(image, 0, 0, this);
        paintBorder(g);
    }
}
