package addbk.JAddressBook.lawyerDataMining;

import addbk.JAddressBook.IndexPanel;
import gui.run.RunMenuItem;
import gui.In;
import net.web.UrlUtils;

import java.util.Vector;

public class LawyerDataMining {
    private IndexPanel indexPanel;
    private String lawyerType;
    private int state;


    public LawyerDataMining(IndexPanel indexPanel) {
        this.indexPanel = indexPanel;


    }

    public RunMenuItem getMenuItem() {
        return new scan4LawyersMenuItem();
    }


    public IndexPanel getIndexPanel() {
        return indexPanel;
    }

    public void setListingNum() {

        Vector v = UrlUtils.getUrlVector(LawyerSearchUtils.getUrlSource(getStateNum(), getLawyerType()));
        LawyerSearchUtils.findListingNum(v);
    }

    public int getStateNum() {
        return state;
    }

    public String getLawyerType() {
        return lawyerType;
    }

    private void setStateProperties(String s, String l) {
        //set state number
        for (int i = 0; i < In.getStates2().length; i++) {
            if (s.equals(In.getStates2()[i])) {
                state = i + 1;
                System.out.println("State(" + state + ")= " + In.getStates2()[i]);
            }
        }
        //set lawyer Type
        for (int i = 0; i < In.getLawyerTypes().length; i++) {
            if (l.equals(In.getLawyerTypes()[i])) {
                lawyerType = In.getLawyerTypesRefNum()[i];
                System.out.println("LawyerType(" + lawyerType + ")=" + In.getLawyerTypes()[i]);
            }
        }
    }

    private class scan4LawyersMenuItem extends RunMenuItem {
        public scan4LawyersMenuItem() {
            super("Scan Lawyers...");
        }

        public void run() {
            String state = In.getState2();
            String lawyerType = In.getLawyerType();
            setStateProperties(state, lawyerType);
            LawyerSearchUtils.scanForLawyers(getStateNum(), getLawyerType());
        }
    }
}
