/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package addbk.JAddressBook;


import gui.run.*;
import gui.touchtone.TouchToneModel;
import gui.touchtone.DialUtils;
import serialPort.Utils;
import sound.dialTones.ToneMap;

import javax.swing.*;
import java.awt.*;
import java.util.Observable;
import java.util.Observer;

public abstract class ViewPanel
        extends JPanel implements Runnable, Observer {

    private AddressRecord ar = new AddressRecord();
    private AddressDataBase adb =
            AddressDataBase.getAddressBookDatabase();
    private RunTextField nameTextField = new RunTextField(20, false) {
        public void run() {
            ar.setName(getText());
        }
    };
    private RunTextArea addressTextArea =
            new RunTextArea(10, 20, false) {
                public void run() {
                    ar.setAddress(getText());
                }
            };
    private RunTextArea notesTextArea =
            new RunTextArea(10, 20, false) {
                public void run() {
                    ar.setInfo(getText());
                }
            };
    private RunTextField dialTextField1 =
            new RunTextField(ar.getDial1(), false) {
                public void run() {
                    ar.setDial1(getText());
                }
            };
    private RunTextField dialTextField2 =
            new RunTextField(ar.getDial2(), false) {
                public void run() {
                    ar.setDial2(getText());
                }
            };
    private RunTextField dialTextField3 =
            new RunTextField(ar.getDial3(), false) {
                public void run() {
                    ar.setDial3(getText());
                }
            };

    public ViewPanel() {
        setLayout(new BorderLayout());
        nameTextField.setText(ar.getName());
        add(nameTextField, BorderLayout.NORTH);
        add(getAddressNotesPanel(), BorderLayout.CENTER);
        add(getSouthPanel(), BorderLayout.SOUTH);
        adb.addObserver(this);
    }

    public void update(Observable observable, Object obj) {
        setValue(adb.getCurrentRecord());
    }


    public void setValue(AddressRecord ar) {
        this.ar = ar;
        nameTextField.setText(ar.getName());
        addressTextArea.setText(ar.getAddress());
        notesTextArea.setText(ar.getInfo());
        dialTextField1.setText(ar.getDial1());
        dialTextField2.setText(ar.getDial2());
        dialTextField3.setText(ar.getDial3());
    }


    public JPanel getSouthPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.add(getPhoneNumberPanel(), BorderLayout.CENTER);
        jp.add(getNavigationPanel(), BorderLayout.EAST);
        jp.add(getDialPanel(), BorderLayout.WEST);
        return jp;
    }

    public JPanel getNavigationPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(0, 1));
        jp.add(
                new RunButton("[Previous") {
                    public void run() {
                        ViewPanel.this.setValue(adb.getPreviousRecord());
                    }
                });
        jp.add(
                new RunButton("[Next") {
                    public void run() {
                        ViewPanel.this.setValue(adb.getNextRecord());
                    }
                });
        jp.add(
                new RunButton("[Index") {
                    public void run() {
                        IndexPanel.setIndexFrameVisible(true);
                    }
                });
        return jp;
    }

    public JPanel getDialPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(0, 1));
        jp.add(
                new RunButton("Dial[1") {
                    public void run() {
                        dial(dialTextField1.getText());
                    }
                });
        jp.add(
                new RunButton("Dial[2") {
                    public void run() {
                        dial(dialTextField2.getText());
                    }
                });
        jp.add(
                new RunButton("Dial[3") {
                    public void run() {
                        dial(dialTextField3.getText());
                    }
                });
        return jp;
    }

    private void dial(String text) {
        final DialBean db = DialBean.restore();
        if (db.isModemDial()) {
            DialUtils.doModemDial(text, db);
        } else
            doSpeakerDial(text, db);
    }

    private void doSpeakerDial(String text, DialBean db) {

        final TouchToneModel ttm =
                new TouchToneModel();
        ttm.setStateString(DialUtils.getFilteredDialString(text, db));
        ToneMap tm = new ToneMap(db);

        tm.playNumber(ttm.getStateString(),db);
    }


    public JPanel getPhoneNumberPanel() {
        JPanel jp = new JPanel();

        jp.setLayout(new GridLayout(0, 1));
        dialTextField1.setEditable(false);
        dialTextField2.setEditable(false);
        dialTextField3.setEditable(false);
        dialTextField1.setBorder(BorderFactory.createEtchedBorder());
        dialTextField2.setBorder(BorderFactory.createEtchedBorder());
        dialTextField3.setBorder(BorderFactory.createEtchedBorder());
        jp.add(dialTextField1);
        jp.add(dialTextField2);
        jp.add(dialTextField3);
        return jp;
    }

    public JPanel getAddressNotesPanel() {
        JPanel jp = new JPanel();
        addressTextArea.setText(ar.getAddress());
        notesTextArea.setText(ar.getInfo());
        addressTextArea.setEditable(false);
        notesTextArea.setEditable(false);
        jp.setLayout(new GridLayout(0, 1));
        addressTextArea.setBorder(BorderFactory.createEtchedBorder());
        notesTextArea.setBorder(BorderFactory.createEtchedBorder());
        jp.add(addressTextArea);
        jp.add(notesTextArea);
        return jp;
    }

    public AddressRecord getValue() {
        ar.setName(nameTextField.getText());
        ar.setAddress(addressTextArea.getText());
        ar.setInfo(notesTextArea.getText());
        ar.setDial1(dialTextField1.getText());
        ar.setDial2(dialTextField2.getText());
        ar.setDial3(dialTextField3.getText());
        return ar;
    }


    public static void main(String[] args) {
        AddressFrame cf = new AddressFrame();
        ViewPanel vp = new ViewPanel() {
            public void run() {
                System.out.println(getValue());
            }
        };
        cf.addComponent(vp);
        cf.setSize(400, 400);
        cf.setVisible(true);
    }
}
