package addbk.JAddressBook;


import futils.Futil;
import gui.In;
import gui.dialogs.LabeledItemPanel;
import gui.dialogs.ModalDialog;
import gui.run.RunButton;
import gui.run.RunCheckBox;
import gui.run.RunPasswordField;
import gui.run.RunTextField;
import net.scp.ScpModelChangeEventListener;

import javax.swing.*;
import java.beans.PropertyChangeSupport;
import java.io.File;

/**
 * net.scp.ScpDialog
 */
public class SecurityDialog extends ModalDialog {

    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private SecurityBean securityBean;


    private LabeledItemPanel c = new LabeledItemPanel();

    public SecurityDialog() {
        init();
    }

    private void init() {
        setTitle("SecurityDialog");
        securityBean = SecurityBean.restore();

        final RunTextField localFileTextField = getLocalFileTextField();
        c.addItem("localFile", localFileTextField);
        c.addItem("setLocalFile", new RunButton("browse") {
            public void run() {
                File f = Futil.getReadFile("select local file");
                localFileTextField.setText(f.getAbsolutePath());
                securityBean.setLocalFile(f.getAbsolutePath());

            }
        });

        c.addItem("user", new RunTextField(securityBean.getUser(), 20) {
            public void run() {
                securityBean.setUser(getText());
            }
        });
        c.addItem("password", new RunPasswordField(securityBean.getPassword(), 20) {
            public void run() {
                securityBean.setPassword(getPasswordString());
            }
        });
        c.addItem("protocol", new protocolCheckbox());
        c.setBorder(BorderFactory.createEtchedBorder());

        setContentPane(c);
    }

    private RunTextField getLocalFileTextField() {
        return new RunTextField(
                securityBean.getLocalFile(), 20) {
            public void run() {
                securityBean.setLocalFile(getText());
            }
        };
    }

    /**
     * This method gets the values of the panel entry fields.
     *
     * @return an object containing the Customer data
     */
    public SecurityBean getData() {
        return securityBean;
    }

    public void addScpChangeEventListener(ScpModelChangeEventListener l) {
        pcs.addPropertyChangeListener(l);
    }

    public void okPressed() {
        if (isValidData()) {
            processOk();
        } else
            debugData();
    }

    private void processOk() {
        securityBean.save();
    }

    public void debugData() {
        In.message("data not valid! Model=" + securityBean);

    }


    /**
     * This method checks that the data entered is valid.
     *
     * @return <code>true</code> if the data is valid, otherwise
     *         <code>false</code>
     */
    protected boolean isValidData() {

        return true;
    }

    public static void main(String[] args) {
        SecurityDialog dialog = new SecurityDialog();
        dialog.pack();
        dialog.setVisible(true);

        System.exit(0);
    }

    private class protocolCheckbox extends RunCheckBox {
        public protocolCheckbox() {
            super("Encrypted", securityBean.isEncoded());
            updateLabel();
        }

        public void run() {
            securityBean.setEncoded(isSelected());
            updateLabel();
        }

        private void updateLabel() {
            if (isSelected())
                setText("Encrypted");
            else
                setText("UnEncrypted");
        }
    }
}