package addbk.JAddressBook;


import gui.In;
import net.scp.ScpModelChangeEvent;
import net.scp.ScpModelChangeEventListener;
import net.scp.ScpTo;
import net.scp.SimpleUserInfo;
import utils.CompactJava;
import utils.PreferencesUtils;
import xml.Utils;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Dec 13, 2004
 * <p/>
 * Time: 6:31:14 AM
 */
public class SecurityBean implements Serializable {

    private String user;
    private String password;

    private String localFile;
    private boolean isEncoded = true;

    private static String key = "addbk.SecurityBean";


    public SecurityBean() {

    }


    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }



    public String getLocalFile() {
        return localFile;
    }

    public void setLocalFile(String localFile) {
        this.localFile = localFile;

    }



    public void setPassword(String password) {
        this.password = password;
    }

    public static SecurityBean fromXml(String xmlString) {
        return (SecurityBean) Utils.decodeXml(xmlString);
    }

    public String toXml() {
        return CompactJava.toXml(this) + "</java>";
    }

    public String toString() {
        return toXml();
    }

    /**
     * saves the properties to the Preferences of the userRoot
     */
    public void save() {
        PreferencesUtils pu = new PreferencesUtils(key);
        pu.save(this);
    }

    /**
     * If uploads file, rerun the following main to
     * re-initialize settings for users.
     * This may occur if UID's or passwords are changed.
     *
     * @param args
     */
    public static void main(String[] args) {
        SecurityBean sm = new SecurityBean();

        sm.setUser("lyon");
        sm.setPassword(In.getPassword("enter password"));

        sm.setLocalFile("/home/lyon/foo");
        sm.save();
        sm = SecurityBean.restore();
        System.out.println(sm);
    }

    /**
     * restores the properties from the preference in the user root.
     */
    public static SecurityBean restore() {
        PreferencesUtils pu = new PreferencesUtils(key);
        Object o = pu.restore();
        if (o instanceof SecurityBean) return (SecurityBean) o;
        return new SecurityBean();
    }

    public void propertyChange(PropertyChangeEvent evt) {

    }


    public String getPassword() {
        return password;
    }



    public boolean isEncoded() {
        return isEncoded;
    }

    public void setEncoded(boolean encoded) {
        isEncoded = encoded;
    }


}
