/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package addbk.JAddressBook;

import gui.run.DelimiterBean;
import gui.run.RunDelimiterPanel;
import gui.run.RunMenu;
import gui.run.RunMenuItem;

import java.awt.*;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 22, 2005
 * <p/>
 * Time: 7:06:35 AM
 */
public class MergeMenu extends RunMenu   {
    private DelimiterBean delimiterBean = DelimiterBean.restore();
    public MergeMenu(){
        super("[Merge");

        add(new RunMenuItem("set delimiters..."){
            public void run(){
                showDelimiterFrame();
            }
        });
        add(new RunMenuItem("merge using delimiters..."){
            public void run(){
                mergeUsingDelimiters();
            }
        });
        add(new RunMenuItem("merge [xml...") {
            public void run() {
                mergeXml();
            };
        });

    }

    private void mergeXml() {
        AddressDataBase adb = AddressDataBase.getAddressBookDatabase();
        adb.mergeXml();
    }

    private void mergeUsingDelimiters(){
        AddressDataBase adb = AddressDataBase.getAddressBookDatabase();
        adb.mergeUsingDelimiters(delimiterBean);
    }
    private void showDelimiterFrame() {
        final AddressFrame cf = new AddressFrame("Delimiter Frame");
        Container c = cf.getContentPane();
        c.add(new RunDelimiterPanel() {
            public void run() {
                delimiterBean = getDelimiterBean();
                cf.setVisible(false);
            }
        });
        cf.pack();
        cf.setVisible(true);
    }
}
