/*
 * Copyright (c) 2005 Your Corporation. All Rights Reserved.
 */
package addbk.JAddressBook;

import gui.In;
import net.web.UrlUtils;

import java.util.Vector;

public class LawyerSearch {
    private static String selected_state;
    private static int names_found = 0;

    public static void main(String[] args) {
        int pagenum = 1;
        boolean more_lawyers = true;
        Vector v;

        selected_state = In.getState();
        int statenum = In.getStateNum(selected_state) + 1;

        while (more_lawyers) {
            String search_string = AddressUrlUtils.getAllLawyers(statenum, pagenum);
            v = UrlUtils.getUrlVector(search_string);

            if (pageHasLawyer(v)) {
                parseAndPrintLawyers(v);

                pagenum++;
            } else {
                more_lawyers = false;
            }
        }

        System.out.println(names_found + " lawyers' names found.");
    }

    private static boolean pageHasLawyer(Vector v) {
        String s;

        for (int i = 0; i < v.size(); i++) {
            s = (String) v.elementAt(i);

            if ((s.indexOf("class='sponseredL'>More Info") == -1) &&
                    (s.indexOf("class='sponseredL'>") > -1)) {
                if (s.indexOf("</a></strong><br>") > -1) {
                    return true;//return true if any line with a name is found
                }
            }
        }

        return false;  //return false if the page contains no lawyer listings
    }

    private static void parseAndPrintLawyers(Vector v) {
        String name;
        String address;
        String city;
        String street;

        String s; //temp string

        for (int i = 0; i < v.size(); i++) {
            s = (String) v.elementAt(i);
            // The line with class='sponseredL'> should be analyzed.
            if ((s.indexOf("class='sponseredL'>More Info") == -1) &&
                    (s.indexOf("class='sponseredL'>") > -1)) {
                int j ;
                j = s.indexOf("class='sponseredL'>") + 19; // 19 is the length of this string.

                name = s.substring(j, s.indexOf("</a></strong><br>")); // Name.

                s = s.substring(s.indexOf("</a></strong><br>") + 17); // trim the string.
                j = s.indexOf("<B>");
                // Street addresses end with <B>.
                // If <B> does not exist, then no address is given.
                if (j == -1) {
                    // Address does not exist.
                    continue;
                }

                street = s.substring(0, s.indexOf("<B>") - 2).trim(); // -1 is for comma.

                s = s.substring(s.indexOf("<B>") + 3); // trim the string.
                city = s.substring(0, s.indexOf("</B>")).trim();

                address = AddressUrlUtils.filterStreet(street) + "\n\t" + city;

                //Print out the lawyers information
                System.out.println(name + "\n\t" + address + ", " + selected_state + "\n ");
                names_found++;
            }
        }
    }
}
