package addbk.JAddressBook;

import gui.run.RunButton;
import gui.run.RunTextArea;
import gui.run.RunTextField;

import javax.swing.*;
import java.awt.*;

public abstract class EditPanel
        extends JPanel implements Runnable {

    private AddressRecord ar = new AddressRecord();
    private AddressRecord oldAr = null;
    private AddressDataBase adb =
            AddressDataBase.getAddressBookDatabase();
    private boolean cancel = false;
    private RunTextField nameTextField = new RunTextField(20) {
        public void run() {
            ar.setName(getText());
        }
    };
    private RunTextArea addressTextArea =
            new RunTextArea(10, 20) {
                public void run() {
                    ar.setAddress(getText());
                }
            };
    private RunTextArea notesTextArea =
            new RunTextArea(10, 20) {
                public void run() {
                    ar.setInfo(getText());
                }
            };
    private RunTextField dialTextField1 =
            new RunTextField(ar.getDial1()) {
                public void run() {
                    ar.setDial1(getText());
                }
            };
    private RunTextField dialTextField2 =
            new RunTextField(ar.getDial2()) {
                public void run() {
                    ar.setDial2(getText());
                }
            };
    private RunTextField dialTextField3 =
            new RunTextField(ar.getDial3()) {
                public void run() {
                    ar.setDial3(getText());
                }
            };

    public void setValue(AddressRecord ar) {
        oldAr = ar;
        nameTextField.setText(ar.getName());
        addressTextArea.setText(ar.getAddress());
        notesTextArea.setText(ar.getInfo());
        dialTextField1.setText(ar.getDial1());
        dialTextField2.setText(ar.getDial2());
        dialTextField3.setText(ar.getDial3());
    }

    public EditPanel() {
        setLayout(new BorderLayout());
        nameTextField.setText(ar.getName());
        add(nameTextField, BorderLayout.NORTH);
        add(getAddressNotesPanel(), BorderLayout.CENTER);
        add(getSouthPanel(), BorderLayout.SOUTH);
    }

    public JPanel getSouthPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.add(getPhoneNumberPanel(), BorderLayout.CENTER);
        jp.add(getButtonControlPanel(), BorderLayout.EAST);
        return jp;
    }

    public JPanel getButtonControlPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(0, 1));
        jp.add(
                new RunButton("[Next") {
                    public void run() {
                        next();
                    }
                });
        jp.add(new RunButton("[Previous") {
            public void run() {
                previous();
            }
        });
        jp.add(
                new RunButton("[Done") {
                    public void run() {
                        adb.replaceCurrentRecord(getValue());
                        EditPanel.this.run();
                    }
                });
        jp.add(
                new RunButton("[Cancel") {
                    public void run() {
                        cancel = true;
                        EditPanel.this.run();
                    }
                });
        return jp;
    }
 
    private void next() {
        adb.replaceCurrentRecord(getValue());
        this.setValue(adb.getNextRecord());
    }
    private void previous() {
        this.setValue(adb.getPreviousRecord());
    }

    public JPanel getPhoneNumberPanel() {
        JPanel jp = new JPanel();

        jp.setLayout(new GridLayout(0, 1));
        dialTextField1.setBorder(BorderFactory.createEtchedBorder());
        dialTextField2.setBorder(BorderFactory.createEtchedBorder());
        dialTextField3.setBorder(BorderFactory.createEtchedBorder());
        jp.add(dialTextField1);
        jp.add(dialTextField2);
        jp.add(dialTextField3);
        return jp;
    }

    public JPanel getAddressNotesPanel() {
        JPanel jp = new JPanel();
        addressTextArea.setText(ar.getAddress());
        notesTextArea.setText(ar.getInfo());
        jp.setLayout(new GridLayout(0, 1));
        addressTextArea.setBorder(BorderFactory.createEtchedBorder());
        notesTextArea.setBorder(BorderFactory.createEtchedBorder());
        jp.add(addressTextArea);
        jp.add(notesTextArea);
        return jp;
    }

    public AddressRecord getValue() {
        if (cancel) return oldAr;
        ar.setName(nameTextField.getText());
        ar.setAddress(addressTextArea.getText());
        ar.setInfo(notesTextArea.getText());
        ar.setDial1(dialTextField1.getText());
        ar.setDial2(dialTextField2.getText());
        ar.setDial3(dialTextField3.getText());
        return ar;
    }

    public static void main(String[] args) {
        showEditFrame();
    }
    public static void showEditFrame(AddressRecord ar) {
        AddressFrame cf = new AddressFrame();
        EditPanel co = new EditPanel() {
                    public void run() {
                        System.out.println(getValue());
                    }
                };
        co.setValue(ar);
        cf.addComponent(co);
        cf.setSize(400, 400);
        cf.setVisible(true);
    }
    public static void showEditFrame() {
        AddressFrame cf = new AddressFrame();
        cf.addComponent(
                new EditPanel() {
                    public void run() {
                        System.out.println(getValue());
                    }
                });
        cf.setSize(400, 400);
        cf.setVisible(true);
    }
}
