/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package addbk.JAddressBook;

import gui.keyboard.KeyTestFrame;
import gui.run.RunMenu;
import gui.run.RunMenuItem;
import gui.touchtone.TouchToneButtonPad;
import gui.touchtone.TouchToneModel;

import javax.swing.*;
import java.awt.*;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Jun 4, 2005
 * <p/>
 * Time: 10:56:00 AM
 */
public class EditMenu {
    public static RunMenu getEditMenu(final IndexPanel indexPanel) {
        RunMenu rm =
                new RunMenu("[Edit");
        rm.add(CopyMenu.getCopyMenu());
        rm.add(
                new RunMenuItem("[New{control n}") {
                    public void run() {
                        indexPanel.newRecord();
                    }
                });
        rm.add(
                new RunMenuItem("[Edit Record{control e}") {
                    public void run() {
                        indexPanel.edit();
                    }
                });
        rm.add(new RunMenuItem("[Delete {control d}") {
            public void run() {
                indexPanel.delete();
            }
        });
        rm.add(new RunMenuItem("[Find{control f}") {
                    public void run() {
                        indexPanel.showFindFrame();
                    }
        });
        rm.add(IndexPanel.getPreferenceMenu(indexPanel));
        rm.add(new RunMenuItem("[Help") {
                    public void run() {
                        Help h = new Help();
                        h.display();
                    }
                });
        rm.add(new RunMenuItem("D[ial Pad{alt n}") {
            public void run() {
                showNumberDialPad();
            }
        });
        return rm;
    }

    private static void showNumberDialPad() {
        KeyTestFrame ktf = new KeyTestFrame();
        final TouchToneModel ttm =
                new TouchToneModel();
        JPanel jp = new JPanel();
        new TouchToneButtonPad(jp, ttm);
        Container c = ktf.getContentPane();
        c.setLayout(new BorderLayout());
        c.add(jp,BorderLayout.CENTER);
        c.add(ttm.getTextField(), BorderLayout.NORTH);
        c.add(new KeyTestFrame.LetterPanel(ttm),BorderLayout.EAST);
        ktf.setSize(300, 300);
        ktf.setVisible(true);
    }
}
