/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package addbk.JAddressBook;

import gui.run.DataMiningBean;
import gui.run.RunMenu;
import gui.run.RunMenuItem;
import addbk.JAddressBook.lawyerDataMining.LawyerDataMining;


/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 22, 2005
 * <p/>
 * Time: 7:06:35 AM
 */
public class DataMiningMenu extends RunMenu   {
    private DataMiningBean dataMiningBean = DataMiningBean.restore();
    private IndexPanel indexPanel;

    public DataMiningMenu(IndexPanel indexPanel){
        super("[Data Mining");
        this.indexPanel = indexPanel;
        initMenuItems();

    }

    private void initMenuItems() {
        add(new RunMenuItem("Scan 4 ct Lawyers") {
            public void run() {
                AddressDataBase adb = AddressDataBase.getAddressBookDatabase();
                AddressUrlUtils.scanForLawyers();
                adb.sort();
                indexPanel.updateLabels();
            }
        });  //
        add(new LawyerDataMining(indexPanel).getMenuItem());

    }

    public void scan4ComputerCompanies() {
        AddressDataBase adb = AddressDataBase.getAddressBookDatabase();
        AddressUrlUtils.scanForComputerCompanies();
        adb.sort();
        indexPanel.updateLabels();
    }

    public DataMiningBean getDataMiningBean() {
        return dataMiningBean;
    }
}
