package addbk.JAddressBook;

import gui.run.RunMenu;
import gui.run.RunMenuItem;

import java.awt.*;
import java.awt.datatransfer.Clipboard;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 30, 2005
 * <p/>
 * Time: 11:10:20 AM
 */
public class CopyMenu {
    public  static RunMenu getCopyMenu() {

        RunMenu rm =
                new RunMenu("[copy");
        rm.add(
                new RunMenuItem("name and address{Control c}") {
                    public void run() {
                        AddressDataBase adb = AddressDataBase.getAddressBookDatabase();
                        final AddressRecord ar = adb.getCurrentRecord();
                        final Toolkit tk = Toolkit.getDefaultToolkit();
                        Clipboard cb = tk.getSystemClipboard();
                        TText tt = new TText(ar.getName() +
                                "\n" +
                                ar.getAddress());
                        cb.setContents(tt, null);
                    }
                });
        rm.add(new RunMenuItem("addressRecord") {
            public void run() {
                AddressDataBase adb = AddressDataBase.getAddressBookDatabase();
                final AddressRecord ar = adb.getCurrentRecord();
                final Toolkit tk = Toolkit.getDefaultToolkit();
                Clipboard cb = tk.getSystemClipboard();
                TText tt = new TText(ar.getName() +
                        "\n" +
                        ar.getAddress()+"\n"+
                        ar.getInfo()+"\n"+
                        ar.getDial1()+"\n"+
                        ar.getDial2() + "\n"+
                        ar.getDial3() + "\n");
                cb.setContents(tt, null);
            }
        });
        rm.add(new RunMenuItem("addressRecord as xml") {
            public void run() {
                AddressDataBase adb = AddressDataBase.getAddressBookDatabase();
                final AddressRecord ar = adb.getCurrentRecord();
                final Toolkit tk = Toolkit.getDefaultToolkit();
                Clipboard cb = tk.getSystemClipboard();
                TText tt = new TText(ar.toXml());
                cb.setContents(tt, null);
            }
        });
        return rm;
    }
}
