package xml.adbk;

import org.xml.sax.helpers.DefaultHandler;

import java.util.Vector;

/**
 *  ParseAml is a <code>DocumentHandler</code>
 *  that can parse AddressBook Markup Language
 */
public class ParseAml
        extends DefaultHandler {

    private AddressBook ab = new AddressBook();
    private Address a = new Address();
    private Vector stringVector = new Vector();

    public AddressBook getAddressBook() {
        return ab;
    }

    public String getLastValue() {
        if (stringVector.size() == 0) return null;

        return (String) stringVector.elementAt(stringVector.size() - 1);
    }

    public void endElement(String s1, String s2, String name) {
        System.out.println("name="+name);
        String sa[] = new String[stringVector.size()];
        stringVector.copyInto(sa);
        /*
                (userId | password |
                title | firstName| lastName)*,
            (streetAddress|address1 | address2| address3 )*,
            (homePage | emailAddress)*,
            (homePhone | businessPhone | faxPhone)*,
            city,
            state,
            zip?)>
        */
        if (name.equals("userId"))
            a.setUserId(getLastValue());
        if (name.equals("password"))
            a.setPassword(getLastValue());
        if (name.equals("title"))
            a.setTitle(getLastValue());
        if (name.equals("firstName"))
            a.setFirstName(getLastValue());
        if (name.equals("lastName"))
            a.setLastName(getLastValue());
        if (name.equals("streetAddress"))
            a.setStreet(getLastValue());
        if (name.equals("address1"))
            a.setAddress1(getLastValue());
        if (name.equals("address2"))
            a.setAddress2(getLastValue());
        if (name.equals("address3"))
            a.setAddress3(getLastValue());
        if (name.equals("homePage"))
            a.setHomePage(getLastValue());
        if (name.equals("emailAddress"))
            a.setEmailAddress(getLastValue());
        if (name.equals("homePhone"))
            a.setHomePhone(getLastValue());
        if (name.equals("businessPhone"))
            a.setBusinessPhone(getLastValue());
        if (name.equals("faxPhone"))
            a.setFaxPhone(getLastValue());
        if (name.equals("company"))
            a.setCompany(getLastValue());
        if (name.equals("zip"))
            a.setZip(getLastValue());
        if (name.equals("state"))
            a.setState(getLastValue());
        if (name.equals("street"))
            a.setStreet(getLastValue());
        if (name.equals("city"))
            a.setCity(getLastValue());

        // if </Address>, we are done with this record
        if (name.equals("Address"))
            addAddressRecord();
    }

    public void addAddressRecord() {
        System.out.println("adding record:" + a.toXml());
        ab.addAddress(a);
        a = new Address();
    }

    /**
     *
     * when characters are found, we add them to
     * the string vector for latter use.
     */
    public void characters(char buf [], int offset, int len) {
        String s = new String(buf, offset, len);
        stringVector.addElement(s);
    }

    public void ignorableWhitespace(
            char buf [], int offset, int len) {
    }

    /**
     * The processingInstruction is
     *  called back when a non XML
     * declaration is made.
     */
    public void processingInstruction(
            String target,
            String data) {
    }
}
