package video.broadcast;

import futils.Futil;
import gui.ClosableJFrame;
import net.multicast.McastUtil;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.*;
import java.net.InetAddress;

/**
 * Copyright DocJava, inc.
 * User: lyon
 * Date: Oct 27, 2004
 * Time: 5:08:08 AM
 */
public class BroadcastViewerThread extends Thread {
    McastUtil mcu;

    public BroadcastViewerThread(McastUtil mcu) {
        this.mcu = mcu;
        setDaemon(false);
        start();                // start calls run
    }

    public void run() {
        String tmp;
        ImageFrame imgFrame = new ImageFrame();
        imgFrame.setVisible(true);
        try {
            while (true) {
                byte[] data = mcu.getBytes();
                InetAddress address = mcu.getInetAddress();
                ByteArrayInputStream bais =
                        new ByteArrayInputStream(data, 0, data.length);
                imgFrame.getImage(bais);
                System.out.println("\n\nRecived: \"" +
                        "ip=" + address +
                        "\"\nMessage Length is: " +
                        data.length);
            }
        } catch (IOException e) {
            System.out.println("Exit...");
            e.printStackTrace();
        }
    }

    public static class ImageFrame extends ClosableJFrame {
        private BufferedImage img = null;

        public void getImage() {
            try {
                File f = Futil.getReadFile("select an image file");
                getImage(f);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void getImage(File f) throws IOException {
            FileInputStream fis = new FileInputStream(f);
            getImage(fis);
        }

        public void getImage(InputStream is) throws IOException {
            BufferedImage bi = ImageIO.read(is);
            is.close();
            setImage(bi);
        }

        public void setImage(BufferedImage bi) {
            img = bi;
            setSize(bi.getWidth(), bi.getHeight());
            repaint();
        }

        public void paint(Graphics g) {
            if (img == null) {
                g.drawString("no data rcvd", 0, this.getHeight() / 2);
                return;
            }
            ;
            Graphics2D g2d = (Graphics2D) g;
            g2d.drawImage(img, null, 0, 0);
        }
    }
}
