/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package utils;

import bookExamples.ch15Streams.Unzipper;
import futils.DirList;
import futils.Futil;
import gui.In;
import net.web.UrlUtils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Mar 6, 2005
 * <p/>
 * Time: 10:07:45 AM
 */
public final class ResourceManager {
    // use singleton design pattern
    private static ResourceManager rm = null;

    private File userDir = new File(utils.SystemUtils.getUserDir());
    private File dataDir = new File(getUserDir(), "data");
    private File dataDir3d = null;
    private File audioDir = null;
    private File imageDir = null;
    private DirList imageDirectoryList = null;
    private DirList dir3dDirectoryList = null;
    private DirList audioDirList = null;

    private void initVariables() {
        dataDir3d = new File(getDataDir(), "3d");
        audioDir = new File(getDataDir(), "audio");
        imageDir = new File(
                getDataDir(),
                "images" +
                SystemUtils.getDirectorySeparator());
        imageDirectoryList = new DirList(
                imageDir,
                new FileFilter() {
                    public boolean accept(File file) {
                        return file.isFile();
                    }

                });
        dir3dDirectoryList = new DirList(
                dataDir3d,
                new FileFilter() {
                    public boolean accept(File file) {
                        return file.isFile();
                    }

                });
        audioDirList = new DirList(
                audioDir,
                new FileFilter() {
                    public boolean accept(File file) {
                        return file.isFile();
                    }

                });
    }

    private boolean dateIsGood() {
        try {
            long dataDirTime = dataDir.getCanonicalFile().lastModified();
            URL resourceUrl = getResourceUrl();
            final URLConnection urlConnection = resourceUrl.openConnection();
            long resourceUrlTime = urlConnection.getLastModified();
            return dataDirTime > resourceUrlTime;
        } catch (IOException e) {
            In.message(e);
        }
        return
                false;
    }

    private static final URL getResourceUrl()
            throws MalformedURLException {
        return new URL(
                "http://showAndRegister.docjava.com:8086/" +
                "book/cgij/code/data/data.jar");
    }

    private void checkForResources() {
        if (dataDir.exists() && dateIsGood()) {
            initVariables();
            return;
        }
        if (dataDir.exists())
            if (In.getBoolean(
                    "Data was updated, " +
                    "delete old data:" +
                    dataDir +
                    " and get new data?"))
                Futil.deleteDirectory(dataDir);
            else {
                initVariables();
                return;
            }

        if (In.getBoolean("Do you want to fix the resources?")) {
            fixResources();
            uncompressResourceFile();
            initVariables();
            return;
        }

        initVariables();
    }


    private ResourceManager() {
    }

    /**
     * A factory method that returns the instance of the ResourceManager
     * and creates it only if needed.
     *
     * @return the only ResourceManager available.
     */
    public static ResourceManager getResourceManager() {
        if (rm != null)
            return rm;
        rm = new ResourceManager();
        rm.checkForResources();
        return rm;
    }

    public static void main(String[] args) {
        do {
            ResourceManager rm = getResourceManager();
            File f[] = rm.getImages();
            for (int i = 0; i < f.length; i++)
                System.out.println(f[i]);
        } while (In.getBoolean("run again?"));
    }

    private void uncompressResourceFile() {
        final File f = new File(dataDir, "data.jar");
        if (!f.exists()) fixResources();
        Unzipper.uncompressJarFile(f);
        f.deleteOnExit();
    }

    private boolean fixResources() {
        URL resourceUrl = null;
        try {
            resourceUrl = getResourceUrl();
            final File f = new File(dataDir, "data.jar");
            if (!dataDir.exists())
                dataDir.mkdirs();
            else if (!In.getBoolean("going to overwrite:" + f + " ok?")) {
                return false;
            }

            getUrl(resourceUrl, f);
            return true;
        } catch (MalformedURLException e) {
            In.message(e);
        } catch (IOException e) {
            In.message(e);
        }
        return
                false;
    }

    private void getUrl(final URL resourceUrl, final File f)
            throws IOException {

        UrlUtils.getUrl(resourceUrl, f);

    }


    public File getAudioFile(String fn) {
        return audioDirList.findFile(fn);
    }

    public URL getAudioURL(String fn) throws MalformedURLException {
        return audioDirList.findFile(fn).toURL();
    }

    public File get3dFile(String fn) {
        return dir3dDirectoryList.findFile(fn);
    }

    public URL get3dURL(String fn) throws MalformedURLException {
        return dir3dDirectoryList.findFile(fn).toURL();
    }

    public File getImageFile(String fn) {
        return imageDirectoryList.findFile(fn);
    }

    public File getImageFile(File f) {
        return getImageFile(f.getName());
    }

    public File getDataDir3d() {
        return dataDir3d;
    }

    public File getImageDir() {
        return imageDir;
    }

    public File getUserDir() {
        return userDir;
    }

    public File getDataDir() {
        return dataDir;
    }

    public File[] getImages(String suffix) {
        return imageDirectoryList.getFiles(suffix);
    }

    public File[] getImages() {
        return imageDirectoryList.getFilesNotDirectories();
    }
}
