package sound.spectrogram;

import gui.ClosableJFrame;
import gui.run.RunSpinner;

import javax.swing.*;
import java.io.Serializable;
import java.awt.*;

import sound.spectrogram.*;

/**
 * Created by Robert Distinti.
 * Copied and reused Java code
 * Only allows number that are a power of 2 (between min and max --also power of 2) 
 * User: default
 * Date: Aug 8, 2005
 * Time: 3:57:17 PM
 */
public class SpinnerNumberModelPow2  extends SpinnerNumberModel implements Serializable
    {
    private int stepSize, value;
    private int minimum, maximum;

    private double logBase2(int length) {
        return (Math.log(length) / Math.log(2));
    }

    public SpinnerNumberModelPow2(int value, int minimum, int maximum, int stepSize) {
        setMaximum(new Integer(maximum));
        setMinimum(new Integer(minimum));
        setStepSize(new Integer(stepSize));
        setValue(new Integer(value));
    }

    public SpinnerNumberModelPow2() {
        this(4, 4, 9,1);
    }

    public void setMinimum(Integer minimum) {
        int q;
        if(minimum.intValue()>0){
            double x=logBase2(minimum.intValue());
            q=1<<(int)Math.ceil(x);
        }else{
            q=1;
        }
        if(q!=this.minimum){
            this.minimum=q;
            setMaximum(new Integer(maximum));
            fireStateChanged();
        }
    }
    public void setMaximum(Integer max) {
        int q=max.intValue();
        if(q>0&&q>minimum){
            double x=logBase2(max.intValue());
            q=1<<(int)Math.ceil(x);
        }else{
            double x=logBase2(minimum+1);
            q=1<<(int)Math.ceil(x);
        }
        if(q!=this.maximum){
            this.maximum=q;
            fireStateChanged();
        }
    }

    public Comparable getMinimum() {
        return new Integer(minimum);
    }


    public Comparable getMaximum() {
        return new Integer(maximum);
    }

    public void setStepSize(Integer step) {
        if(step.intValue()>0){
            double x=logBase2(step.intValue());
            int e=1<<(int)Math.ceil(x);
            if (e<maximum){
                stepSize=step.intValue();
            }
        }else{
            this.stepSize=1;
        }
        fireStateChanged();
    }


    public Number getStepSize() {
        return new Integer(stepSize);
    }


    private Number incrValue(int dir)
    {
        int newValue=value;
        if(dir>0){
            if(value<maximum){
                double x=logBase2(value);
                int y=1<<((int)Math.ceil(x)+stepSize);
                if(y>maximum){
                    newValue=maximum;
                }else{
                    newValue=y;
                }
            }
        }else if(dir<0){
            if(value>minimum){
                double x=logBase2(value);
                int y;
                if(x>stepSize){
                    y=1<<((int)Math.ceil(x)-stepSize);
                }else{
                    y=0;
                }
                if(y<minimum){
                    newValue=minimum;
                }else{
                    newValue=y;
                }
            }
        }
        return new Integer(newValue);
    }


    public Object getNextValue() {
        return incrValue(+1);
    }

    public Object getPreviousValue() {
        return incrValue(-1);
    }

    public Number getNumber() {
        return incrValue(0);
    }


    public Object getValue() {
        return incrValue(0);
    }

    public void setValue(Integer newValue){
        if ((newValue == null) || !(newValue instanceof Number)) {
            throw new IllegalArgumentException("illegal value");
        }
        int q=newValue.intValue();
        if(q<1)q=1;
        double x=logBase2(q);
        int y=1<<((int)Math.ceil(x));
        if(y>maximum)y=maximum;
        if(y<minimum)y=minimum;
        if(value!=y){
            value=y;
            fireStateChanged();
        }
    }

    public void setValue(Object value) {
        if ((value == null) || !(value instanceof Integer)) {
            throw new IllegalArgumentException("illegal value");
        }
        setValue((Integer)value);
    }

    public static void main(String args[]) {
        ClosableJFrame cf = new ClosableJFrame();
        final Container contentPane = cf.getContentPane();
        contentPane.add(new sound.spectrogram.RunSpinner2(new SpinnerNumberModelPow2()) {
            public void run() {
                System.out.println(getValue());
            }
        });

        cf.setSize(400, 75);
        cf.setVisible(true);

    }
}

