package sound.spectrogram;

/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 * modified by bob 
 */

import gui.ClosableJFrame;
import gui.run.RunSpinner;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

public abstract class RunSpinner2 extends JSpinner
        implements Runnable, ChangeListener {
    //private static final int PAGE_SIZE = 5;
    public RunSpinner2(SpinnerModel sm) {
        setModel(sm);
        sm.addChangeListener(this);
        registerKeyboardAction(new PgUpMover(),
                KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, 0),
                JComponent.WHEN_IN_FOCUSED_WINDOW);
        registerKeyboardAction(new PgDnMover(),
                KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_DOWN, 0),
                JComponent.WHEN_IN_FOCUSED_WINDOW);
        registerKeyboardAction(new HomeMover(),
                KeyStroke.getKeyStroke(KeyEvent.VK_HOME, 0),
                JComponent.WHEN_IN_FOCUSED_WINDOW);
        registerKeyboardAction(new EndMover(),
                KeyStroke.getKeyStroke(KeyEvent.VK_END, 0),
                JComponent.WHEN_IN_FOCUSED_WINDOW);


    }
    public SpinnerNumberModel getNumberModel() {
        return (SpinnerNumberModel)getModel();
    }


    public void stateChanged(ChangeEvent event) {
        run();
    }
    class PgUpMover implements ActionListener {
        SpinnerModel nm = getNumberModel();
        public void actionPerformed(ActionEvent e) {
            nm.setValue(nm.getPreviousValue());
        }
    }
    class PgDnMover implements ActionListener {
        SpinnerModel nm = getNumberModel();
        public void actionPerformed(ActionEvent e) {
            nm.setValue(nm.getNextValue());
        }
    }

    /**
     * Moves Spinner's value to minimum
     */
    class HomeMover implements ActionListener {
        SpinnerNumberModel nm = getNumberModel();
        public void actionPerformed(ActionEvent e) {
            nm.setValue(nm.getMinimum());
        }
    }



    class EndMover implements ActionListener {
        SpinnerNumberModel nm = getNumberModel();
        public void actionPerformed(ActionEvent e) {
            nm.setValue(nm.getMaximum());
        }
    }
    public static void main(String args[]) {
        ClosableJFrame cf = new ClosableJFrame();
        final Container contentPane = cf.getContentPane();
        contentPane.add(new RunSpinner2(new SpinnerNumberModel()) {
            public void run() {
                System.out.println(getValue());
            }
        });

        cf.setSize(400, 75);
        cf.setVisible(true);

    }
}
