package sound.recorder;

import javax.sound.sampled.*;
import java.io.IOException;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Dec 13, 2004
 * Time: 1:21:07 PM
 */
public class FilteredAudioInputStream extends AudioInputStream {
    private AudioInputStream ais;
    private AudioFormat audioFormat;
    private SoundFilter soundFilter;
    private static final int REMAINING_SIZE_UNKNOWN = -1;
    SourceDataLine sourceDataLine;
    TargetDataLine tdl;
    public FilteredAudioInputStream(TargetDataLine tdl) {
        super(tdl);
        AudioFormat audioFormat = tdl.getFormat();
        this.tdl = tdl;
    }
    public FilteredAudioInputStream(AudioInputStream ais, AudioFormat af, long frameLength, SoundFilter soundFilter) {
        super(ais, af, frameLength);
        this.soundFilter = soundFilter;
        this.ais = ais;
        audioFormat = ais.getFormat();
        DataLine.Info dataLineInfo = new DataLine.Info(SourceDataLine.class, audioFormat);
        try {
            sourceDataLine = (SourceDataLine) AudioSystem.getLine(dataLineInfo);
            sourceDataLine.open(audioFormat);
        } catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    public int read(byte[] samples, int offset, int length)
            throws IOException {
        int remainingSize = length - offset;
        int bytesRead = super.read(samples, offset, length);
        if (bytesRead > 0) {
            soundFilter.filter(samples, offset, bytesRead);
            return bytesRead;
        }
        ;
        if (remainingSize == REMAINING_SIZE_UNKNOWN) {
            remainingSize = soundFilter.getRemainingSize();
            remainingSize = remainingSize / 4 * 4;
        }
        ;
        if (remainingSize > 0) {
            length = Math.min(length, remainingSize);
            for (int i = offset; i < offset + length; i++) {
                samples[i] = 0;
            }
            ;
            soundFilter.filter(samples, offset, length);
            remainingSize -= length;
            return length;
        } else {
            return -1;
        }
    }
}
