package sound.player;

import futils.Futil;
import gui.In;
import sound.Oscillator;

import javax.sound.sampled.*;
import java.io.IOException;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Dec 28, 2004
 * <p/>
 * Time: 1:38:08 PM
 */
public class FromFile {
    public static void main(String[] args) {
        try {
            testFromOscillator();
        } catch (LineUnavailableException e) {
            In.message(e);

        } catch (IOException e) {
            In.message(e);

        }
    }

    private static void testFromOscillator() throws LineUnavailableException,
                                             IOException {
        double d[] = Oscillator.getSineWave(440, 880, 1000);
        Oscillator.playLinearData(d);


    }

    private static void testFromFile() {
        do
            playAudioFromFile();
        while (In.getBoolean("again?"));
    }

    public static void print(AudioFormat af) {
        System.out.println(af);
        System.out.println(
                "\ngetFrameRate=" +
                af.getFrameRate() +
                "\n" +
                "getFrameSize=" +
                af.getFrameSize() +
                "\n" +
                "getSampleRate=" +
                af.getSampleRate() +
                "\n" +
                "getSampleSizeInBits=" +
                af.getSampleSizeInBits() +
                "\n" +
                "getChannels=" + af.getChannels());
    }

    public static void playAudioFromFile() {
        try {
            // From file
            AudioInputStream stream = AudioSystem.getAudioInputStream(
                    Futil.getReadFile("select an audio file"));
            // At present, ALAW and ULAW encodings must be converted
            // to PCM_SIGNED before it can be played
            AudioFormat format = stream.getFormat();
            if (format.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
                format = new AudioFormat(
                        AudioFormat.Encoding.PCM_SIGNED,
                        format.getSampleRate(),
                        format.getSampleSizeInBits() * 2,
                        format.getChannels(),
                        format.getFrameSize() * 2,
                        format.getFrameRate(),
                        true);        // big endian
                print(format);
                stream = AudioSystem.getAudioInputStream(format, stream);
            }

            // Create the clip
            DataLine.Info info = new DataLine.Info(
                    Clip.class,
                    stream.getFormat(),
                    (
                    (int) stream.getFrameLength() * format.getFrameSize()));
            Clip clip = (Clip) AudioSystem.getLine(info);

            // This method does not return until the audio file is completely loaded
            clip.open(stream);

            // Start playing
            clip.start();
        } catch (Exception e) {
            In.message(e);

        }

    }
}
