package sound.musica;

import javax.swing.*;
import java.awt.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/**
 * The <code>ExitFrame</code>
 * will terminate the JVM upon
 * closing. This is suggested
 * for JAWS, so that resources
 * can be released.
 */
public class ExitFrame extends JFrame {
    public ExitFrame() {
        this("");
    }

    public ExitFrame(String title) {
        super(title);
        setBackground(Color.white);
        addWindowListener(
                new ClosingWindowAdapter());
    }

    public void addMouseController(gui.mouse.MouseController mc) {
        addMouseMotionListener(mc);
        addMouseListener(mc);
    }

    public static void main(String args[]) {
        ExitFrame cf = new ExitFrame("ClosableJFrame");
        cf.setSize(200, 200);
        cf.setVisible(true);

    }

    private class ClosingWindowAdapter
            extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            setVisible(false);
            dispose();
            System.exit(0);
        }
    }
}