/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package sound.dialTones;

import gui.In;
import gui.run.DialBean;
import gui.touchtone.DialUtils;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: May 2, 2005
 * <p/>
 * Time: 6:28:42 AM
 */
public class ToneMap {
    private DialBean db = DialBean.restore();

    public ToneMap(){
        
    }
    public ToneMap(DialBean db){
        this.db = db;
    }
    public DTMF[] getDtmfs(String s) {
        char ca[] = s.toCharArray();
        DTMF d[] = new DTMF[ca.length];
        for (int i = 0; i < ca.length; i++)
            d[i] = getDtmf(ca[i]);
        return d;
    }
    public DTMF[] getDtmfs(String s,DialBean db) {
        char ca[] = s.toCharArray();
        DTMF d[] = new DTMF[ca.length];
        for (int i = 0; i < ca.length; i++)
            d[i] = getDtmf(ca[i]);
        return d;
    }

    public void play(DTMF d[]) {
        for (int i = 0; i < d.length; i++)
            d[i].play();
    }

    public void playNumber(String s) {
        if (s == null) return;
        DialBean db = DialBean.restore();
        if (!db.isModemDial())
            play(getDtmfs(s));
        else
            DialUtils.doModemDial(s,db);
    }
    public void playNumber(String s,DialBean db) {
        if (s == null) return;
        play(getDtmfs(s,db));
    }
    /**
     * Map a character into two DTMF tones. If the character cannot be
     * found, the frequency is -1.
     * The low bands are:
     * 697, 770, 852 and 941.
     * The high bands are:
     * 1209, 1336 and 1477 Hz.
     * See Mitra, 3E, Digital Signal Processing,
     * pp. 29 for more information.
     * Band 1633 Hz is normally not used, but
     * we can implement it anyway.
     */
    public DTMF getDtmf(char c) {
        int F1 = -1;
        int F2 = -1;
        switch (c) {
            case 'a':
                F1 = 1633;
                F2 = 697;
                break;
            case 'b':
                F1 = 1633;
                F2 = 770;
                break;
            case 'c':
                F1 = 1633;
                F2 = 852;
                break;
            case 'd':
                F1 = 1633;
                F2 = 941;
                break;
            case '0':
                F1 = 1336;
                F2 = 941;
                break;
            case '1':
                F1 = 1209;
                F2 = 697;
                break;
            case '2':
            case 'A':
            case 'B':
            case 'C':
                F1 = 1336;
                F2 = 697;
                break;
            case '3':
            case 'D':
            case 'E':
            case 'F':
                F1 = 1477;
                F2 = 697;
                break;
            case '4':
            case 'G':
            case 'H':
            case 'I':
                F1 = 1209;
                F2 = 770;
                break;
            case '5':
            case 'J':
            case 'K':
            case 'L':
                F1 = 1336;
                F2 = 770;
                break;
            case '6':
            case 'M':
            case 'N':
            case 'O':
                F1 = 1477;
                F2 = 770;
                break;
            case '7':
            case 'P':
            case 'Q':
            case 'R':
            case 'S':
                F1 = 1209;
                F2 = 852;
                break;
            case '8':
            case 'T':
            case 'U':
            case 'V':
                F1 = 1336;
                F2 = 852;
                break;
            case '9':
            case 'W':
            case 'X':
            case 'Y':
            case 'Z':
                F1 = 1477;
                F2 = 852;
                break;
            case '*':
                F1 = 1209;
                F2 = 941;
                break;
            case '#':
                F1 = 1477;
                F2 = 941;
                break;
            case ',': // pause
                F1 = 0;
                F2 = 0;
                break;
            default:
                F1 = -1;
                F2 = -1;
        }
        return new DTMF(F1, F2,db);
    }

    public static void main(String args[]) {
        ToneMap tm = new ToneMap(DialBean.restore());
        do
            tm.playNumber(In.getString("enter a phone number:"));
        while (In.getBoolean("again?"));
        System.exit(0);
    }

}
