package sound;

import gui.ClosableJFrame;
import math.Mat1;
import math.fourierTransforms.FFT1d;
import sound.ulaw.UlawCodec;

import java.awt.*;

/**
 * Created by IntelliJ IDEA.
 * User: lyon
 * Date: Jul 5, 2005
 * Time: 5:23:19 PM
 */
public class NoiseUtils {
    public static void main(String[] args) {
        testAudioFft();

    }

    public static void testAudioFft() {
        UlawCodec ulc = new UlawCodec();
        //ulc.play();
        Oscillator o = new Oscillator(440, 1 << 15);
        //double d[] = o.getSineWave();
        double d [] =
                makeIntegralPowerOfTwo(ulc.getDoubleArray());

        addNoise(d, 0.5);
        Mat1.scale(d, 1.0 / d.length);
        System.out.println("d=" + d.length);
        FFT1d f = new FFT1d();
        double[] imag = new double[d.length];
        f.computeForwardFFT(d, imag);

        double psd[] = f.getPSD();
        double noisePowerCutoff = 0.05;

        noiseFilter(f,noisePowerCutoff);
        f.computeBackwardFFT(f.getRealData(), f.getImaginaryData());
        OscopePanel op = new OscopePanel(psd);
        ClosableJFrame cjf = new ClosableJFrame("psd");
        Container c = cjf.getContentPane();
        c.setLayout(new BorderLayout());
        c.add(op, BorderLayout.CENTER);
        cjf.setSize(400, 400);
        cjf.setVisible(true);
        Mat1.scale(d, 0.92);
        ulc = new UlawCodec(d);
        ulc.play();
    }

    private static void noiseFilter(FFT1d f, double noisePowerCutoff) {
       double psd[]= f.getPSD() ;
        double r[] = f.getRealData();
        double im[] = f.getImaginaryData();
        for (int i = 0; i < psd.length; i++) {
            if (psd[i]<noisePowerCutoff){
                r[i] = 0;
                im[i]=0;
            };

        }

    }

    public static double[] makeIntegralPowerOfTwo(double[] in) {
        int n = logBase2(in.length);
        double out[] = new double[1 << n];
        for (int i = 0; i < out.length; i++) {
            out[i] = in[i];
        }
        return out;
    }

    private static int logBase2(int length) {
        return (int) (Math.log(length) / Math.log(2));
    }

    private static double[] getDouble(float[] audio) {

        double f[] = new double[audio.length];
        for (int i = 0; i < f.length; i++) {
            f[i] = audio[i];

        }
        return f;
    }

    private static float[] getFloat(double[] audio) {

        float f[] = new float[audio.length];
        for (int i = 0; i < f.length; i++) {
            f[i] = (float) audio[i];

        }
        return f;
    }

    private static void benchMark(double[] audio) {
        for (int i = 0; i < 10; i++) {
            addNoise(audio, 0.1f);
            audio = addNoiseSlow(audio);
        }
        final int n = 100;

        long time = System.currentTimeMillis();
        for (int i = 0; i < n; i++) {
            addNoise(audio, 0.1f);
        }
        time = System.currentTimeMillis() - time;
        long slowTime = System.currentTimeMillis();
        for (int i = 0; i < n; i++) {
            audio = addNoiseSlow(audio);
        }
        slowTime = System.currentTimeMillis() - slowTime;
        System.out.println("time fast=" + time +
                "\n slow time = " + slowTime);
    }

    public final static void addNoise(double d[], double amp) {
        for (int i = 0; i < d.length; i++) {
            d[i] = d[i] + amp * (Math.random() - 0.5);
        }
    }

    public final static double[] addNoiseSlow(double d[]) {
        double out[] = new double[d.length];
        for (int i = 0; i < d.length; i++) {
            out[i] = d[i] + 0.1 * (Math.random() - 0.5);
        }
        return out;
    }
}
