/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package serialPort.test;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: May 14, 2005
 * <p/>
 * Time: 4:58:10 AM
 */



import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;

import java.io.InputStream;
import java.util.Enumeration;

import serialPort.CommPortUtils;

public class PortTest {
    public static void main(String[] args) {

        CommPortIdentifier portId;
        Enumeration
                e = CommPortIdentifier.getPortIdentifiers();

        System.out.println("Ports found:");

        while (
                e.hasMoreElements()) {
            portId = (CommPortIdentifier)
                    e.nextElement();
            System.out.println("  - " + portId.getName());
        }

        CommPortUtils cpu = CommPortUtils.getCommPortUtils();

        portId = cpu.getACommPort();



        int val;
        byte[] valArray = new byte[128];

        try {
            SerialPort port = (SerialPort) portId.open("PortTest", 5000);
            InputStream in = port.getInputStream();

            System.out.println(
                    "[" + portId.getName() + "] 'read()' test (0, 0):");
            port.disableReceiveTimeout();
            port.disableReceiveThreshold();
            val = in.read();
            System.out.println("[" + val + "]");

            System.out.println(
                    "[" +
                    portId.getName() +
                    "] 'read()' test (5000, 0):");
            port.enableReceiveTimeout(5000);
            val = in.read();
            System.out.println("[" + val + "]");

            System.out.println(
                    "[" +
                    portId.getName() +
                    "] 'read()' test (5000, 5):");
            port.enableReceiveThreshold(5);
            val = in.read();
            System.out.println("[" + val + "]");

            System.out.println(
                    "[" + portId.getName() + "] 'read()' test (0, 5):");
            port.disableReceiveTimeout();
            val = in.read();
            System.out.println("[" + val + "]");

            System.out.println(
                    "[" +
                    portId.getName() +
                    "] 'read(byte[])' test (0, 0):");
            port.disableReceiveTimeout();
            port.disableReceiveThreshold();
            val = in.read(valArray);
            System.out.println("[" + val + "]");

            System.out.println(
                    "[" +
                    portId.getName() +
                    "] 'read(byte[])' test (5000, 0):");

            port.enableReceiveTimeout(5000);
            val = in.read(valArray);
            System.out.println("[" + val + "]");

            System.out.println(
                    "[" +
                    portId.getName() +
                    "] 'read(byte[])' test (5000, 5):");

            port.enableReceiveThreshold(5);
            val = in.read(valArray);
            System.out.println("[" + val + "]");

            System.out.println(
                    "[" +
                    portId.getName() +
                    "] 'read(byte[])' test (0, 5):");

            port.disableReceiveTimeout();
            val = in.read(valArray);
            System.out.println("[" + val + "]");

            System.out.println(
                    "[" +
                    portId.getName() +
                    "] 'read(byte[], int, int)' test (0, 0):");
            port.disableReceiveTimeout();
            port.disableReceiveThreshold();
            val = in.read(valArray, 0, 3);
            System.out.println("[" + val + "]");

            System.out.println(
                    "[" +
                    portId.getName() +
                    "] 'read(byte[], int, int)' test (5000, 0):");
            port.enableReceiveTimeout(5000);
            val = in.read(valArray, 0, 3);
            System.out.println("[" + val + "]");

            System.out.println(
                    "[" +
                    portId.getName() +
                    "] 'read(byte[], int, int)' test (5000, 5):");
            port.enableReceiveThreshold(5);
            val = in.read(valArray, 0, 3);
            System.out.println("[" + val + "]");

            System.out.println(
                    "[" +
                    portId.getName() +
                    "] 'read(byte[], int, int)' test (0, 5) (len = 3):");
            port.disableReceiveTimeout();
            val = in.read(valArray, 0, 3);
            System.out.println("[" + val + "]");

            System.out.println(
                    "[" +
                    portId.getName() +
                    "] 'read(byte[], int, int)' test (0, 5) (len = 10):");
            port.disableReceiveTimeout();
            val = in.read(valArray, 0, 10);
            System.out.println("[" + val + "]");

            port.close();
        } catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }
}
