package serialPort;

import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

/**
 * Simple Java Communications API Test Program:
 * <p/>
 * This is a simple example of writing and reading from a comm port.
 * <p/>
 * Additionally it will illustrate the following:
 * - Discovering all available serial ports and using the first one
 * (unless one is specified on the command line)
 * - How to use the USB port add-on on to the Java Communcations API
 * using the rcx.comm package.
 * (requires a specific port name on the command line e.g. LEGOTOWER1 )
 */
public class SimpleWriteRead {

    // statics to allow use in main() which is static 
    static Enumeration portList;
    static CommPortIdentifier portId;
    static SerialPort serialPort;
    static OutputStream outputStream;
    static InputStream inputStream;


    public static void main(String[] args) {
        CommPortUtils cpu = CommPortUtils.getCommPortUtils();
        portId = cpu.getACommPort();



        // SETUP SERIAL PORT:
        try {
            serialPort = (SerialPort) portId.open("SimpleWriteRead", 1000);
        } catch (PortInUseException e) {
            System.out.println("port already in use");
            return;
        }

        try {
            serialPort.setSerialPortParams(9600,
                    SerialPort.DATABITS_8,
                    SerialPort.STOPBITS_1,
                    SerialPort.PARITY_ODD);
            serialPort.enableReceiveTimeout(30);
            serialPort.enableReceiveThreshold(14);
        } catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
        }

        try {
            outputStream = serialPort.getOutputStream();
            inputStream = serialPort.getInputStream();
        } catch (IOException e) {
            e.printStackTrace();
        }


// now write and read (same way for both types of ports)

// write a message out:
        String s = "atdt8774187";
        int numread=0;
        byte testArray1[] = s.getBytes();
        try {
            sendData(testArray1, s);

            byte[] readBuffer = new byte[30];
             numread = readData(readBuffer, s);
            if (numread>0)
                System.out.println(new String(readBuffer));
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static int readData(byte[] readBuffer, String s) throws IOException {
        int numBytes;
        int numread;
        numBytes = 1;
        numread = 0;

// read a message in:
        while (numBytes > 0) {
            numBytes = inputStream.read(readBuffer, 0, 30);
            if (numBytes > 0)
                System.out.println("read response to 'alive' message... ("
                        + numBytes + " bytes)"
                        + s);
            numread += numBytes;
        }
        return numread;
    }

    private static void sendData(byte[] testArray1, String s) throws IOException {
        System.out.println("sending 'alive' message... ("
                + testArray1.length + " bytes) "
                + s);

        outputStream.write(testArray1); //alive msg
    }

    public static Vector getAvailableSerialPorts() {
        CommPortIdentifier pId;
        SerialPort sPort = null;
        Enumeration pList;
        boolean foundport;
        CommPortUtils cpu = CommPortUtils.getCommPortUtils();
        if (cpu == null) return null;
        pList = CommPortIdentifier.getPortIdentifiers();
        Vector ports = new Vector();

        if (!pList.hasMoreElements()) {
            System.err.print("warning: no ports found - ");
            System.err.println("make sure javax.comm.properties file is found");
            return ports;
        }
        while (pList.hasMoreElements()) {
            pId = (CommPortIdentifier) pList.nextElement();
            if (pId.getPortType() == CommPortIdentifier.PORT_SERIAL) {
                foundport = true;
                try {
                    sPort = (SerialPort) pId.open("serialport", 1000);
                } catch (PortInUseException e) {
                    foundport = false;
                } finally {
                    if (sPort != null) {
                        try {
                            sPort.close();
                        } catch (Exception e) {
                        }
                    }
                    if (foundport) {
                        ports.add(pId.getName());
                    }
                }
            }
        }
        return ports;
    }
}
