package security;

//import classUtils.pack.DependencyUtils;

import classUtils.pack.PackUtils;
import futils.DirList;
import futils.Futil;
import gui.In;
import net.rmi.utils.Compile;
//import sun.security.tools.JarSigner;
import utils.SystemUtils;

import java.io.File;
import java.io.IOException;

/**
 * DocJava, Inc. User: lyon Date: May 26, 2004 Time: 7:40:22 AM
 */
public class SignUtils {
    public static void main(String[] args) {
        signOneJarGui();

    }

    public static void testJarSigner() {
        File jarFile = Futil.getReadFile("select a jar");
        String args[] = {
            "-verify",
            "-verbose",
            jarFile.getName()

        };
        jarSignerRun(args, jarFile);

    }

    public static void jarSignerRun(String args[], File workingDir) {
        String a[] = new String[args.length + 1];
        a[0] = SystemUtils.getJarSignerPath().toString();
        for (int i = 1; i < a.length; i++)
            a[i] = args[i - 1];
        try {
            if (workingDir != null)
                Compile.runExec(a, workingDir.getParentFile());
            else
               Compile.runExec(a, workingDir);
        } catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("done");
    }

    public static void signGui() {
        WebStartBean wsb = WebStartBean.getFromPreferences();
        final String ks = wsb.getKeyStoreFile();
        final String pw = In.getPassword("enter keystore pswd");
        final String alias = wsb.getAlias();
        wsb.setPassword(pw);
        wsb.save();
        DirList dl = new DirList(Futil.getReadFileDir("select a dir of jars"), ".jar");
        File f[] = dl.getFiles(".jar");
        for (int i = 0; i < f.length; i++) {
            System.out.println("signing:" + f[i]);
            sign(ks, pw, f[i], alias);
        }

    }
    public static void signOneJarGui(){
        WebStartBean wsb = WebStartBean.getFromPreferences();
        wsb.setPassword(In.getPassword("enter keystore pswd"));
        wsb.save();
        signOneJar(wsb);

    }
    public static void signOneJar(WebStartBean wsb) {
        do {
            final File readFile = Futil.getReadFile("select jarfile");
            sign(wsb.getKeyStoreFile(),
                    wsb.getPassword(),
                    readFile,
                    wsb.getAlias());
            verify(readFile);
        } while (In.getBoolean("again?"));
    }

    public static void testPackSignAndVerify() {
        String className = "dhry.Main";

        String keystoreName = "keystore";
        String storepass = "password";
        String alias = "docjava";

        packSignAndVerify(className,
                keystoreName,
                storepass,
                alias);
    }

    public static void packSignAndVerify() {
        packSignAndVerify(gui.In.getString("enter class name"),
                futils.Futil.getReadFile("select keystore") + "",
                gui.In.getString("enter password"),
                gui.In.getString("enter alias"));

    }


    public static void packSignAndVerify(String className,
                                         String keystoreName,
                                         String storepass,
                                         String alias) {
        File jarFileName = new File(className + ".jar");
        try {
            PackUtils.pack(className,
                    jarFileName);
        } catch (Exception e) {
            In.message(e);
            return;
        }
        sign(keystoreName,
                storepass,
                jarFileName,
                alias);

        verify(jarFileName);
    }

    public static void jarIt() {
        String a[] = {
            "-help"
        };
        sun.tools.jar.Main.main(a);
    }
    /**
     * Assume that the keystore password and the certificate
     * password are the same. If they are not, you will be prompted
     * during normal jarsigner use to enter the certificate password.
     * To change the password of the certificate in the keystore, use:
     * <p>
     * <code>
     *  keytool -keypasswd -alias duke -keypass dukekeypasswd -new newpass
     * </code>
     * <p>
     * To change the password of the keystore, use:
     * <p>
     * <code>
     * jarsigner -keypass newDukeKeyPassword
     * </code>
     * @param keystoreName fully qualified path to keystore.
     * @param storepass   certificate and store password
     * @param jarFileName thing to be signed
     * @param alias  certificate name
     */
    public static void sign(String keystoreName,
                            String storepass,
                            File jarFileName,
                            String alias) {
        //JarSigner js = new JarSigner();

        String a[] = {
            "-keystore",
            keystoreName,
            "-storepass",
            storepass,
            jarFileName.getAbsolutePath(),
            alias

        };
        //js.run(a);
        jarSignerRun(a,jarFileName.getParentFile());
    }

    /**
     * This method causes the callers thread of execution to terminate
     * after the run!
     */
    public static void verify(File jarFileName) {
        //JarSigner js = new JarSigner();
        System.out.println("verifying:" + jarFileName);
        String a[] = {
            "-verify",
            "-verbose",
            jarFileName.getAbsolutePath(),

        };
        //js.run(a);
        jarSignerRun(a,jarFileName.getParentFile());
    }
}
