package security;

import classUtils.putils.ClassPathUtils;
import futils.Futil;
import gui.In;
import gui.dialogs.LabeledItemPanel;
import gui.run.RunButton;
import gui.run.RunPasswordField;
import gui.run.RunTextField;

import javax.swing.*;
import java.awt.*;
import java.io.File;
import java.io.IOException;

/**
 * This class demonstrates the usage of the StandardDialog class.
 */
public class InitiumDialog extends JDialog {
    private WebStartBean wsb = null;
    private JLabel jarFileNameLabel = null;
    private RunJnlpPanel runJnlpPanel = new RunJnlpPanel() {
        public void run() {

        }
    };


    public WebStartBean getWebStartBean() {
        return wsb;
    }

    public InitiumDialog(WebStartBean wsb) {
        this.wsb = wsb;
        jarFileNameLabel = new JLabel(wsb.getJarFileName());
        init();
        pack();
        ClassPathUtils.restoreClassPath();
    }

    private void init() {
        setTitle("Initium  Dialog");
        setModal(true);

        LabeledItemPanel c = getLabeledItemPanel();
        addTextFields(c);

        c.addItem("",runJnlpPanel);
        c.addItem("",getOkCancelPanel());

        JScrollPane jsp = new JScrollPane(c);
        setContentPane(jsp);

    }

    private JPanel getOkCancelPanel()  {
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout());
        jp.add(new RunButton("OK") {
            public void run() {
                if (wsb.isValid()) {
                    InitiumDialog.this.setVisible(false);
                } else In.message("data not valid");
            }
        });
        jp.add(new RunButton("exit") {
            public void run() {
                System.exit(0);
            }
        });
        return jp;
    }

    private LabeledItemPanel getLabeledItemPanel() {
        final LabeledItemPanel l = new LabeledItemPanel();
        l.setBorder(BorderFactory.createEtchedBorder());
        return l;
    }

    private void addTextFields(LabeledItemPanel c) {
        c.addItem("Vendor", new RunTextField(wsb.getVendor()) {
            public void run() {
                wsb.setVendor(getText());
            }
        });
        c.addItem("web server", new RunTextField(wsb.getWebServer()) {
            public void run() {
                wsb.setWebServer(getText());
            }
        });
        c.addItem("rootDirectory",
                new RunTextField(wsb.getRootDirectory()) {
                    public void run() {
                        wsb.setRootDirectory(getText());
                    }
                });
        c.addItem("ws/ks user id", new RunTextField(wsb.getWebServerUid()) {
            public void run() {
                wsb.setWebServerUid(getText());
            }
        });
        c.addItem("ws/ks Password", new RunPasswordField(
                wsb.getPassword()) {
            public void run() {
                wsb.setPassword(getPasswordString());
            }
        });
        c.addItem("alias",
                new RunTextField(wsb.getAlias()) {
                    public void run() {
                        wsb.setAlias(getText());
                    }
                });
        c.addItem("keystore file",
                new RunTextField(wsb.getKeyStoreFile()) {
                    public void run() {
                        wsb.setKeyStoreFile(getText());
                    }
                });
        c.addItem("icon url",
                new RunTextField(wsb.getIconUrl()) {
                    public void run() {
                        wsb.setIconUrl(getText());
                    }
                });
        c.addItem("host url",
                new RunTextField(wsb.getHostUrl()) {
                    public void run() {
                        wsb.setHostUrl(getText());
                    }
                });
        c.addItem("code base",
                new RunTextField(wsb.getCodeBase()) {
                    public void run() {
                        wsb.setCodeBase(getText());
                    }
                });

        final RunTextField classNameTextField = getClassNameTextField();


        c.addItem("class name",
                getClassNamePanel(classNameTextField,
                        getBrowseButton(classNameTextField)));
        c.addItem("jar file name", jarFileNameLabel);

    }

    private RunTextField getClassNameTextField() {
        return new RunTextField(wsb.getClassName()) {
                            public void run() {
                                final String className = getText();
                                setClassName(className);
                            }
                        };
    }

    private RunButton getBrowseButton(
            final RunTextField classNameTextField) {
        final RunButton browseButton = new RunButton("...") {
                            public void run() {
                                File f = Futil.getReadFile("select .class file");
                                if (f==null) return;
                                if (!f.canRead()) return;
                                try {

                                    setClassGui(f, classNameTextField);
                                } catch (IOException e) {
                                    In.message(e);
                                    return;
                                }
                            }
                        };
        return browseButton;
    }

    private void setClassGui(File f, final RunTextField classNameTextField)
            throws IOException {
        final String className =
                ClassPathUtils.getClassName(f);
        setClassName(className);
        classNameTextField.setText(className);
    }

    private JPanel getClassNamePanel(
            final RunTextField classNameTextField,
            final RunButton browseButton) {
        JPanel classNamePanel = new JPanel();
        classNamePanel.setLayout(new BorderLayout());
        classNamePanel.add(classNameTextField,BorderLayout.CENTER);
        classNamePanel.add(browseButton,BorderLayout.EAST);
        return classNamePanel;
    }

    private void setClassName(final String className) {
        wsb.setClassName(className);
        wsb.setJarFileName(className + ".jar");
        updateJarFileName();
    }

    private void updateJarFileName() {
        jarFileNameLabel.setText(wsb.getJarFileName());
    }

    public JnlpBean getJnlpBean() {
       return  runJnlpPanel.getValue();
    }
}