package net.web;

import java.io.*;
import java.net.Socket;
import java.net.URL;

public class BinaryWebServer {
    public static void main(String args[]) {
         net.proxy.Proxy.setSoeProxy();
         new BinaryWebServer(80);
    }
    public BinaryWebServer(int port) {

        try {
            java.net.ServerSocket ss
                    = new java.net.ServerSocket(port);
            while (true) {
                new PortMappingService(ss.accept());
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}

class BinaryThreadedService implements
        Runnable {
    private Socket clientsSocket;
    private BufferedReader socketsBufferedReader;
    private OutputStream socketsOutputStream;
    private static final String
            notFoundString =
            "HTTP/1.0 501 Not Implemented\n"
            + "Content-type: text/plain\n";
    private static final String
            okString =
            "HTTP/1.0 200 OK\n"
            + "Content-type: text/html\n";
    private static final String
            gifString =
            "HTTP/1.0 200 OK\n"
            + "Content-type: image/gif\n";
    private static final String
        auString =
            "HTTP/1.0 200 OK\n"
             + "Content-type: sound/au\n";



    BinaryThreadedService(Socket _s) {

        clientsSocket = _s;
        try {
            socketsBufferedReader =
                    new BufferedReader(
                            new InputStreamReader(
                                    clientsSocket.getInputStream()));
            socketsOutputStream = clientsSocket.getOutputStream();
        } catch (IOException e) {
            e.printStackTrace();
        }
        Thread t = new Thread(this);
        t.start();
    }

    public void run() {
        try {
            String line =
                    socketsBufferedReader.readLine();
            java.util.StringTokenizer
                    st =
                    new java.util.StringTokenizer(
                            line);
            System.out.println(line);
            if (st.nextToken().equals("GET"))
            //countTo10();
                //getATextFile(st);
                //getABinaryFile(st);
                getABinaryUrl(st);
            else
                println(notFoundString);
            socketsOutputStream.close();
            clientsSocket.close();
        } catch (Exception e) {
        }
    }

    public void println() {
        println("");
    }

    public void println(String s) {
        s = s + "\n";
        byte b[] = s.getBytes();
        try {
            socketsOutputStream.write(b);
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    public void countTo10() {
        println("HTTP/1.0 200 OK");
        println("Content-type: text/plain");
        println("");
        for (int i = 0; i < 100000; i++)
            println("i=" + i);
    }

    public void getATextFile(java.util.StringTokenizer st)
            throws FileNotFoundException,
            IOException {
        println(okString);
        String fileName
                = st.nextToken();
        println("date=" + new java.util.Date());
        BufferedReader
                fileReader = new
                        BufferedReader(new
                                FileReader(
                                        "c:\\lyon\\www" + fileName));
        String fileLine = null;
        while (
                (fileLine =
                fileReader.readLine())
                != null)
            println(fileLine);
    }

    public void getABinaryUrl(java.util.StringTokenizer st)
            throws FileNotFoundException,
            IOException {
        String urlName
                = st.nextToken();
        urlName = "http:/"+urlName;
        //Vector v = UrlUtils.getUrl(urlName);
         //      System.out.println("urlName="+urlName);
        URL url = new URL(urlName);
        InputStream
                urlIs =      url.openStream();
        byte b [] = new byte[1024];
        int numberRead = -1;
        while ( (numberRead = urlIs.read(b))>0)
            socketsOutputStream.write(b);
    }

    public void getABinaryFile(java.util.StringTokenizer st)
            throws FileNotFoundException,
            IOException {
        println(gifString);
        String fileName
                = st.nextToken();

        BufferedInputStream
                filesBufferedInputStream = new
                        BufferedInputStream(
                                new FileInputStream(
                                        "c:\\lyon\\www" + fileName));
        byte b [] = new byte[1024];
        int numberRead = -1;
        while ( (numberRead = filesBufferedInputStream.read(b))>0)
            socketsOutputStream.write(b);
    }
}
