package net.stocks;

import java.awt.*;
import java.util.Vector;

public class QuoteFrame extends
                        gui.ClosableJFrame {
  Vector quotes = new Vector();
  Label labels[];

  public void init() {
    getQuotes();
    setBackground(Color.white);
    labels = new Label[quotes.size()];
    for (int i = 0; i < quotes.size(); i++) {
      String s =
          (String) quotes.elementAt(i);
      quoteLineToStringVector(s);
      labels[i] = new Label(s);
      addComponent(labels[i]);
    }
    setContainerLayout(new GridLayout(0, 1));
    pack();
    setVisible(true);
  }

  public String[] quoteLineToStringVector(String pcs) {
    Vector stringVector =
        new Vector();
    String s = new String(pcs);
    //separate the strings delimited by commas
    for (
        int i = s.indexOf(',');
        i >= 0;
        i = s.indexOf(',')) {
      stringVector.addElement(s.substring(0, i));
      s = new String(s.substring(i + 1));
    }
    // add the last String left
    stringVector.addElement(s);
    String sa[] =
        new String[stringVector.size()];
    for (int i = 0; i < sa.length; i++)
      sa[i] = (String) stringVector.elementAt(i);
    return sa;
  }

  public void println(String s[]) {
    for (int i = 0; i < s.length; i++)
      System.out.println(s[i]);
  }

  public void print(String s[]) {
    for (int i = 0; i < s.length; i++)
      System.out.print(s[i] + " ");
    System.out.println();
  }

  public void updateDisplay() {
    getQuotes();
    for (int i = 0; i < quotes.size(); i++) {
      labels[i].setText(
          (String) quotes.elementAt(i));
    }
  }

  public void paint(Graphics g) {
    updateDisplay();
    repaint(2000);
  }

  public Vector getQuotes() {
    Vector s = new Vector();
    s.addElement("aapl");
    s.addElement("open");
    s.addElement("xlnx");
    s.addElement("altr");
    s.addElement("mot");
    s.addElement("cy");
    s.addElement("crus");
    s.addElement("mtwkf");
    s.addElement("sfa");
    s.addElement("adbe");
    s.addElement("nn");
    s.addElement("msft");
    s.addElement("sunw");
    s.addElement("lxk");
    s.addElement("ATHM");
    s.addElement("AMZn");
    s.addElement("NT");
    return quotes =
        Quote.getUrl(
            Quote.makeQuoteURLString(s));
  }

  public static void main(String args[]) {
    QuoteFrame qf = new QuoteFrame();
    qf.init();
  }

}