package net.server.servlets;

/**
 * The Student class encapsulates the functionality
 * required to represent a student. The data members of
 * the class hold pertinent information such as the
 * first and last names and middle initial of the student
 * as well as the student's identification, or record number.
 * Getter methods are supplied to obtain each of these data
 * members. The constructor of the class enables the
 * setting of each of these parameters.
 *
 * @author Robert Lysik
 * @version 1.00
 */
class Student {
    private String firstName;
    private String lastName;
    private String middleInitial;
    private int studentRecordNumber;

    /**
     * This is the default constructor for the
     * Student class.
     */
    Student() {
    }

    /**
     * This Student constructor enables the setting of each
     * of the member variables of the Student class.
     *
     */
    Student(String first,
            String middle,
            String last,
            int number) {
        firstName = first;
        lastName = last;
        middleInitial = middle;
        studentRecordNumber = number;
    }

    /**
     * This is the getter method for the student's first
     * name.
     */
    public String getFirstName() {
        return firstName;
    }

    /**
     * This is the getter method for the student's full
     * name. The name is a composite of the first name,
     * middle initial and last name.
     */
    public String getFullName() {
        return firstName + " " + middleInitial + ". " + lastName;
    }

    /**
     * This is the getter method for the student's last
     * name.
     */
    public String getLastName() {
        return lastName;
    }

    /**
     * This is the getter method for the student's middle
     * initial.
     */
    public String getMiddleInitial() {
        return middleInitial;
    }

    /**
     * This is the getter method for the student's record
     * number.
     */
    public int getStudentRecordNumber() {
        return studentRecordNumber;
    }

    /**
     * This is the setter method for the student's first
     * name.
     */
    public void setFirstName(String fname) {
        firstName = fname;
    }

    /**
     * This is the setter method for the student's last
     * name.
     */
    public void setLastName(String lname) {
        lastName = lname;
    }

    /**
     * This is the setter method for the student's middle
     * initial.
     */
    public void setMiddleInitial(String mname) {
        middleInitial = mname;
    }

    /**
     * This is the setter method for the student's record
     * number.
     */
    public void setStudentRecordNumber(int srnumber) {
        studentRecordNumber = srnumber;
    }
}