package net.server.servlets;


/**
 * The SelectCoursePage class is a type of HTML page
 * which is used to prompt a user to select a course id.
 *
 * @author Robert Lysik
 * @version 1.00
 */
class SelectCoursePage extends net.server.servlets.HtmlPage {

    /**
     * This is the default constructor for the
     * SelectCoursePage class. The parent constructor
     * is caller with the page title, 'Course Selection Page'.
     * A form is added to the page which is used to prompt
     * the user to select a course id from a drop down list.
     * The form data is passed to the FormProcessorServlet
     * class when the user clicks 'Enter'.
     */
    SelectCoursePage(String[] courseIds, Course[] courses) {
        super("Course Selection Page");

        addText("Select a course ID from the following list:");
        startForm("get",
                "http://localhost:8080/examples/servlet/FormProcessorServlet");
        addBreak();
        addText(getSelect("course", "1", courseIds, courseIds));
        addBreak();
        addSubmit("Enter");
        addHidden("status", "course_id_selected");
        endForm();
    }
}