package net.server.servlets;

/**
 * The HtmlTable class encapsulates the functionality
 * required to construct an HTML representation of a table.
 *
 * The number of rows and columns of the required table
 * are specified as arguments to the constructor, as is the
 * size of the border drawn around the table.
 *
 * The table can then be populated with data items using
 * the setItem method.
 *
 * To retrieve the resulting table, the getHtml method is
 * invoked.
 *
 * @author Robert Lysik
 * @version 1.00
 */
public class HtmlTable {
    // Data members of the HtmlTable class
    // which will be used to construct an
    // HTML representation of a table.
    private int rows;
    private int cols;
    private int border;
    private String tableItem[][];

    /**
     * This function sets the value of an element in the
     * table specified by the parameters r and c passed
     * in as arguments.
     *
     */
    public HtmlTable(int r,
                     int c,
                     int b) {
        rows = r;
        cols = c;
        border = b;
        tableItem = new String[rows][cols];
    }

    /**
     * This function sets the value of an element in the
     * table specified by the parameters r and c passed
     * in as arguments.

     */
    public void setElement(int r,
                           int c,
                           String value) {
        tableItem[r][c] = value;
    }

    /**
     * This function returns the value of the element in
     * the table as specified by the r and c parameters
     * passed in as arguments.
     *
     */
    public String getElement(int r,
                             int c) {
        return tableItem[r][c];
    }

    /**
     * This function returns the HTML script to generate
     * the table as a string.
     */
    public String getHtml() {
        String html = new String();

        // Start the table definition with the opening HTML tag
        html = "<table border = " + border + ">\r\n";

        // Loop through each row and column index for the table
        // Prefix each new row with the <tr> HTML tag, and
        // each element in the row using the <td> tag. The
        // value for each item is stored in the tableItem String
        // array.
        for (int rowIndex = 0; rowIndex < rows; rowIndex++) {
            html += "<tr>\r\n";
            for (int colIndex = 0; colIndex < cols; colIndex++) {
                html += "<td>" +
                        (tableItem[rowIndex][colIndex]) +
                        "\r\n";
            }
        }

        // Add the closing tag for the table.
        html += "</table>\r\n";

        return html;
    }
}
