package net.rmi.rmiimage;

import java.awt.*;

public class RectangleComponent
    extends MovableComponent {
  private boolean on = true;

  public RectangleComponent(boolean state) {
    on = state;


  }

  public void setState(boolean _on) {
    on = _on;
    repaint();
  }

  public void paint(Graphics g) {
    setBackground(Color.white);
    Point pt = getLocation();
    Dimension d = getPreferredSize();
    if (on)
      g.fillRect(pt.x, pt.y, d.width, d.height);
    else
      g.drawRect(pt.x, pt.y, d.width, d.height);
  }

}