package net.rmi.rmiimage;

import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public abstract class MovableComponent
    extends Component
    implements MouseMotionListener,
    MouseListener {
  private int w = 10;
  private int h = 5;
  private boolean initialized = init();
  private int x1,y1,x2,y2;

  private boolean init() {
    addMouseMotionListener(this);
    addMouseListener(this);
    setCursor(
        Cursor.getPredefinedCursor(
            Cursor.HAND_CURSOR));
    return true;
  }

  public Dimension getPreferredSize() {
    return new Dimension(w, h);
  }

  public void mouseReleased(MouseEvent e) {
  }

  public void mouseEntered(MouseEvent e) {
  }

  public void mouseExited(MouseEvent e) {
  }

  public void mouseClicked(MouseEvent e) {
  }

  public void mouseDragged(MouseEvent e) {
    e.consume();
    x1 = x2;
    y1 = y2;
    x2 = e.getX();
    y2 = e.getY();
    setLocation(x2, y2);
    repaint();
  }

  public void mouseMoved(MouseEvent e) {
  }

  public void mousePressed(MouseEvent e) {
    e.consume();
    x1 = e.getX();
    y1 = e.getY();
    x2 = -1;
  }
}
