package net.rmi.rmiimage;

import java.awt.*;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class CpuPanel
    extends Panel implements
    BenchMarkListener, ItemListener {
  private CpuControlPanel cpucp
      = new CpuControlPanel();

  private Label speedLabel =
      new Label("0");

  private Choice cpuInfo
      = new Choice();

  private RectangleComponent
      onLightComponent =
      new RectangleComponent(false);
  private Checkbox cb =
      new Checkbox("on", true);
  private static
      int cpuNumber = 0;
  private float speed = 0;

  CpuPanel(String cpuName, String IPAddress, String model) {
    setBackground(Color.white);
    cpuNumber++;
    setLayout(new GridLayout(0, 1));
    cpucp.add(onLightComponent);
    cpucp.add(cb);
    cb.addItemListener(this);
    cpucp.add(speedLabel);
    cpuInfo.add("CPU:" + cpuNumber);
    cpuInfo.add(cpuName);
    cpuInfo.add(IPAddress);
    cpuInfo.add(model);

    cpuInfo.setBackground(Color.white);

    add(cpucp);
    add(cpuInfo);
  }

  public void setSpeed(float _speed) {
    speed = _speed;
    speedLabel.setText
        ("     " + speed);

  }

  public float getSpeed() {
    return speed;
  }

  public void setLightOn(boolean on) {
    onLightComponent.setState(on);
    cb.setState(on);
  }

  boolean getstate() {
    return (cb.getState());
  }

  void checkboxChanged() {
    onLightComponent.setState(cb.getState());
    //activate cpu or
    //deactivecpu
  }

  public void itemStateChanged(ItemEvent e) {
    if (e.getSource() == cb) {
      checkboxChanged();
      return;
    }
  }
}