package net.rmi.rjs.pk.rmiFileTransfer;


import futils.Futil;
import net.rmi.rjs.pk.LusCs.CSAnswerFactory;
import net.rmi.rjs.pk.LusCs.RemoteJob;
import net.rmi.rjs.pk.LusCs.LusAnwserFactory;
import utils.SystemUtils;

import java.io.File;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

/**
 * Created by IntelliJ IDEA. User: pkrepszt Date: Mar 13, 2005 Time:
 * 7:25:37 PM To change this template use File | Settings | File
 * Templates.
 */
public class FileServerImplementation
        extends UnicastRemoteObject
        implements FileTransInterface {

    public static String REMOTE_NAME = "RmiFileServerMain";
    public FileServerImplementation()
            throws RemoteException {
    }
    /**
     * This is implements in the computer server in order
     * to obtain a job, executed and return the answer to the LUS
     * via the putFile.
     * @param rj
     * @throws RemoteException
     */
    public void putJob(RemoteJob rj, String wsAnwserURL) throws RemoteException {
        File f = new File(SystemUtils.getUserHome() +
                SystemUtils.getDirectorySeparator() +
                rj.getJarFileName());
        Futil.writeBytes(f, rj.getJarContents());
        //new CSAnswerFactory(f, rj.getReturnAddress(),wsAnwserURL);
    }
    /**
     * Call this method to put data into the file system of
     * a remote server.
     * Use this to put an answer into the LUS from the CS.
     *
     * @param fileName
     * @param data
     * @throws RemoteException
     */
    public void putFile(String fileName, byte data[])
            throws RemoteException {
        if (data == null) System.out.println("Data=null!");
        File f = new File(
                SystemUtils.getUserHome() +
                SystemUtils.getDirectorySeparator() +
                fileName);
        Futil.writeBytes(f, data);
        System.out.println("wrote file to Lus:" + f.getAbsolutePath());
    }

    public String putURL(String URL, String webServerIP, String lusIpAddress) throws RemoteException {
        System.out.println("new CSAnswerFactory(URL, webServerIP, lusIpAddress);");
       new CSAnswerFactory(URL, webServerIP, lusIpAddress);
       return URL;
    }

    public File getFile(String fileName, String ip) throws RemoteException {
        File f = new File(
                SystemUtils.getUserHome() +
                SystemUtils.getDirectorySeparator() +
                fileName);
        return f;
    }

    public void runLusAnwserFactory(String fileName, byte data[], String wsAnwserURL){
        File f = new File(
                SystemUtils.getUserHome() +
                SystemUtils.getDirectorySeparator() +
                fileName);
        Futil.writeBytes(f, data);
        new LusAnwserFactory(f, wsAnwserURL);

    }
}

