package net.rmi.rjs.pk.rmiFileTransfer;

import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import net.rmi.utils.RmiRegistryUtils;

/**
 * Created by IntelliJ IDEA. User: pkrepszt Date: Mar 13, 2005 Time:
 * 7:30:21 PM To change this template use File | Settings | File
 * Templates.
 */
public final class FileServer {
    private static FileServer fs = null;

    public static void startFileServer() {
        if (fs == null) {
        //System.out.println("fs = null");
          fs = new FileServer();
        }
      // System.out.println("fs not null null");
    }

    private FileServer() {

        try {
            startServer();
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }


    private void startServer()
            throws RemoteException {
        println("starting server");
        bindInstances(new FileServerImplementation());
    }


    private void bindInstances(FileServerImplementation fsi) {
        println("binding remote instances");
        Registry r = RmiRegistryUtils.getRegistry();
      
        System.out.println("registry="+r);
        //System.out.println("FileTransInterface:"+fsi);
        try {
            r.rebind(FileServerImplementation.REMOTE_NAME, fsi);
        } catch (RemoteException e) {
            e.printStackTrace();
        }
        println("waiting for invocations");

    }

    public static void println(Object o) {
        System.out.println(o);
    }
}
