
package net.rmi.rjs.pk.LusCs;

import futils.Futil;
import gui.In;
import utils.SystemUtils;

import java.io.File;
import java.io.IOException;


public final class WebStartLauncher {

     private WebStartLauncher(){}

    /**
     *Start web start on the given url, then kill the process, to showAndRegister we
     * have control over stopping and starting a process.
     * You must call exit in your web start application or this
     * code will NEVER FINISH.
     * The Correct way to do this is to monitor a directory
     * that contains the output and upload it after it is
     * done writing.
     * @param  webStartUrl URL of the jnlp job file
     * @return answer jar
     */
    public static final File startWebstartAndWaitForAnswer(String webStartUrl) {
        String ds = SystemUtils.getUserHome() + SystemUtils.getDirectorySeparator() +
                "rjs" + SystemUtils.getDirectorySeparator();
        File answerDir = new File(ds);
        if (!answerDir.exists()) answerDir.mkdir();
        //Clen up the dir, delete aal files
        File []l= answerDir.listFiles();
        while(l.length>0){
        for(int i=0; i < l.length; i++){
            if(l[i].canWrite()&& (l[i].getName()!= "ans") ) {
            System.out.println("deleteng from "+ds +" file "+ l[i].getName());
            l[i].delete();
            }

        }
          l= answerDir.listFiles();
        }

        File webStart = getWebstartLocation();

        String args[] = {webStart.toString(),webStartUrl};
        try {

            Runtime rt = Runtime.getRuntime();
            rt.exec(args, null, null);
            File answer = waitForAnswer(answerDir);
            System.out.println("got an answer:" + answer);
            return answer;
        } catch (IOException e) {
            e.printStackTrace();
        }

        return null;
    }

   /**
    * Waits for the answer jar to arrive
    * @param answerDir
    * @return answer jar
    */
    public static final File waitForAnswer(File answerDir) {
        while (true) {
            File answer = getJarFilesOnly(answerDir.listFiles());
            if (answer == null) {
                sleepASec();
                continue;
            } else if (answer.canWrite()) return answer;
            sleepASec();
        }
    }
   /**
    * Scans the array of files for jar files
    * @param fileList
    * @return jar file
    */
    private static final File getJarFilesOnly(File[] fileList){
        File jar = null;
        for(int i=0; i < fileList.length; i++){
            if(fileList[i].getName().endsWith(".jar")){
               jar=fileList[i];
               return jar;
            }
        }
        return jar;
    }

    /**
     * sleep for 2 sec while waiting on answer file
     */
    private static final void sleepASec() {
        try {
            System.out.println("sleeping");
            Thread.sleep(2000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

   /**
     *Search for the Java web start application. If you cannot find it,
     * prompt the user. In the future, there should be a better way to do
     * this, but what, I don't know. And what if javaws cannot be found
     * because it is not installed? Tricky!
    * @return  the java webstart file
    */
    public static final File getWebstartLocation() {
        System.out.println(SystemUtils.getJavaHome());
        String s = SystemUtils.getDirectorySeparator();
        // check widows location:
        String st = (SystemUtils.getJavaHome() +
                s +
                "bin" +
                s +
                "javaws.exe");
        File f = new File(SystemUtils.getJavaHome() +
                s +
                "bin" +
                s +
                "javaws.exe");
        if (f.exists()) return f;
        //still windows
        f = new File(SystemUtils.getJavaHome() +
                s +
                "javaws" +
                s +
                "javaws.exe");
        if (f.exists()) return f;
        // check mac location:
        f = new File("/" +
                "Applications" +
                s +
                "Utilities" +
                s +
                "Java" +
                s +
                "Java Web Start.app" +
                s +
                "Contents" +
                s +
                "MacOS" +
                s +
                "Java Web Start");
        if (f.exists()) return f;
        // check linux location for jdk1.5:
        f = new File("" +
                s +
                "usr" +
                s +
                "java" +
                s +
                "j2sdk1.5.0" +
                s +
                "bin" +
                s +
                "javaws");
        if (f.exists()) return f;
        // check linux location for jdk1.5:
        f = new File(SystemUtils.getJavaHome() +
                s +
                "bin" +
                s +
                "javaws");
        if (f.exists()) return f;
        f =
                Futil.getReadFile(st);
        if (f == null) {
            In.message("user canceled operation, program terminates");
            System.exit(0);
        }
        String cn = "security.WebstartUtils";
        System.out.println("please add:" + f + " to" + cn);
        return f;
    }
}
