/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package net.rmi.rjs.pk.LusCs;

import gui.run.RunJob;

import java.net.InetAddress;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: May 1, 2005
 * <p/>
 * Time: 3:11:47 PM
 */
public class CsRecords {
    private Vector v = new Vector();

    public static final double leastTimeInSeconds = 10;

    public CsRecord[] getRecords() {
        CsRecord a[] = new CsRecord[v.size()];
        v.copyInto(a);
        return a;
    }

    public void add(CsRecord r) {
        v.addElement(r);
    }

    public void startScanner() {
        new RunJob(leastTimeInSeconds) {
            public void run() {
                removeOldRecords();
            }
        };
    }
    //return record thet IP =  ipAddress
    public void deleteRecord (InetAddress ipAddress){
        CsRecord a[] = getRecords();
        for (int i = 0; i < a.length; i++)
            if(a[i].getIpAddress()== ipAddress)
                removeRecord(a[i]);

    }
    public void updateState(InetAddress ipAddress, boolean state){
        CsRecord a[] = getRecords();
        for (int i = 0; i < a.length; i++)
            if(a[i].getIpAddress()== ipAddress)
                a[i].setBusy(state);
    }
    public void removeOldRecords() {
        CsRecord a[] = getRecords();
        for (int i = 0; i < a.length; i++)
            deleteIfOld(a[i]);
    }

    /**
     * Check to see if the lease has expired
     */
    private void deleteIfOld(CsRecord csRecord) {
        if (csRecord.getAge() > leastTimeInSeconds) {
            removeRecord(csRecord);
        }
    }

    public void removeRecord(CsRecord csr) {
        v.remove(csr);
    }

    public String toString() {
        CsRecord a[] = getRecords();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < a.length; i++) {
            sb.append(a[i].toString());
            sb.append("\n-------------------------------" +
            "-------------------------------------------" +
            "--------------------------------------------\n");

        }
        return sb.toString();
    }

    public CsRecord getLeastLoaded() {
        sort();
        System.out.println(toString());
        if (v.size()==0) {
            System.out.println("no cs servers found!");
            return null;
            //System.exit(0);
        }
        CsRecord crs = (CsRecord) v.elementAt(0);
        if(! crs.isBusy()){
            crs.setBusy(true);
            return (CsRecord) v.elementAt(0);
        }
        else
            return getLeastLoadedIdle();

    }
   public CsRecord getLeastLoadedIdle(){
       System.out.println("best ip is busy getting next best");
       CsRecord crs = null;
       for(int i = 0; i < v.size(); i++){
           crs = (CsRecord) v.elementAt(i);
           if(!crs.isBusy()){
               crs.setBusy(true);
               return crs;
           }


       }
       System.out.println("next best is " + crs.getIpAddress());
     return null;
   }
    public void sort() {
        Collections.sort(
                v, new CsRecordComparator());
    }

    private static class CsRecordComparator implements Comparator {
        public int compare(Object o, Object o1) {
            CsRecord cs1 = (CsRecord) o;
            CsRecord cs2 = (CsRecord) o1;
            BenchMarkBean bmb1 = cs1.getBmb();
            BenchMarkBean bmb2 = cs2.getBmb();
            return (int) (bmb2.getMflops() - bmb1.getMflops() );
        }

        public boolean equals(Object o) {
            return false;
        }
    }
}
