/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package net.rmi.rjs.jobs;

public class MandelTables {

     protected int maxIter = 30;
     protected short[] colorR = new short[maxIter];
     protected short[] colorG = new short[maxIter];
     protected short[] colorB = new short[maxIter];
     public MandelTables(){
         float deltaTheta = (float) (Math.PI / maxIter);
         for (int i = 0; i < maxIter; i++) {
             colorR[i] = (short) (Math.sin((i * deltaTheta)) * 255f);
             colorG[i] = 0;
             colorB[i] = (short) (i * 255 / maxIter);
         }
     }
 }
