/*
 * Created on Jun 14, 2005
 */
package net.rmi.rjs.jobs;

import gui.ClosableJFrame;
import j2d.Images;
import j2d.ShortImageBean;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;

/**
 * @author Francisco Castellanos
 *         The clases below have the purpose of testing the Fractals class,
 *         and to display the results.
 */

public class FractalsTest {

    public static void main(String[] args) {
        Dimension d = new Dimension(400, 400);
        FractalsImageFrame frame = new FractalsImageFrame(d, 8);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setSize(d.width, d.height);
        frame.setVisible(true);
    }
}

class FractalsImageFrame extends ClosableJFrame {

    public FractalsImageFrame(Dimension d, int noParts) {

        FractalsImagePanel imp = new FractalsImagePanel(d, noParts);
        FractalsButtonPanel bp = new FractalsButtonPanel(imp.getImages());
        Container c = getContentPane();
        c.setLayout(new BorderLayout());
        addComponent(imp, BorderLayout.CENTER);
        addComponent(bp, BorderLayout.SOUTH);
    }
}

class FractalsImagePanel extends javax.swing.JPanel {

    private FractalLogic fl;
    private Fractals f;
    private int noParts;
    private final Dimension jobDimension;
    FractalShortImageBean sib = null;
    private Image[] images;

    public FractalsImagePanel(Dimension d, int parts) {
        //setLayout(new FlowLayout(FlowLayout.LEFT));
        noParts = parts;
        setLayout(new GridLayout((int) Math.ceil((double) noParts / 2), 2, 3, 3));
        jobDimension = d;
        f = new Fractals();
        fl = f.getFractalLogic();
        fl.getAns().add(f.getComputeJobs(jobDimension, noParts));
        Answers ans = fl.getAns();
        Serializable sa[] = ans.getAnswers();
        while (sa.length < noParts) {
            sa = ans.getAnswers();
            try {
                Thread.sleep(1000);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("got:" + sa.length + " answers.");
        images = new Image[sa.length];
        for (int i = 0; i < sa.length; i++) {
            Serializable s = sa[i];

            if (s instanceof ShortImageBean) {
                sib = (FractalShortImageBean) s;
                //imgs.add(sib.getProcessedImage());
            }
            final Image img = sib.getProcessedImage();
            images[sib.getPositionY()] = img;
            FractalImgPanel fjp = new FractalImgPanel(img);
            add(fjp);

        }
    }

    public Image[] getImages() {
        return images;
    }

}

class FractalImgPanel extends JPanel {
    private Image img;

    public FractalImgPanel(Image image) {
        img = image;
        //this.setSize(img.getWidth(null), img.getHeight(null));
        //System.out.println("Size = " + img.getWidth(null) + ", " + img.getHeight(null));
    }

    public void paintComponent(Graphics g) {
        g.drawImage(img, 0, 0, null);
    }
}

class FractalsButtonPanel extends JPanel {

    public FractalsButtonPanel(final Image[] imgs) {

        Button b1 = new Button("Put it together");
        ActionListener l = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Dimension d = new Dimension(400, 400);
                FImageFrame f = new FImageFrame(imgs);
                f.setSize(d.width, d.height);
                f.setVisible(true);
            }
        };
        b1.addActionListener(l);
        add(b1);
    }
}

class FImageFrame extends ClosableJFrame {

    Images images = new Images();

    public FImageFrame(Image[] imgs) {

        Dimension d = new Dimension(imgs[0].getWidth(null), imgs[0].getHeight(null));


        for (int i = 0; i < imgs.length; i++) {
            images.add(imgs[i]);
        }

        FractalImgPanel imp = new FractalImgPanel(images.getImage(d, 1, imgs.length));
        Container c = getContentPane();
        c.setLayout(new BorderLayout());
        addComponent(imp, BorderLayout.CENTER);

    }
}
